/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.rest;

import flexjson.JSONSerializer;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.URLDecoder;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.jdo.JDOException;
import javax.jdo.JDOFatalUserException;
import javax.jdo.JDOHelper;
import javax.jdo.JDONullIdentityException;
import javax.jdo.JDOObjectNotFoundException;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Query;
import javax.jdo.spi.Detachable;
import javax.jdo.spi.JDOImplHelper;
import javax.jdo.spi.PersistenceCapable;
import javax.jdo.spi.StateManager;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.OMFContext;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.jdo.JDOPersistenceManager;
import org.datanucleus.jdo.JDOPersistenceManagerFactory;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.TypeConversionHelper;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class RestServlet
extends HttpServlet {
    PersistenceManagerFactory pmf;
    public static final NucleusLogger LOGGER_REST = NucleusLogger.getLoggerInstance((String)"DataNucleus.REST");
    static /* synthetic */ Class class$org$datanucleus$rest$RestServlet;
    static /* synthetic */ Class class$java$lang$String;

    public void init(ServletConfig config) throws ServletException {
        System.setProperty("appengine.orm.disable.duplicate.pmf.exception", "true");
        String factory = config.getInitParameter("persistence-context");
        try {
            this.pmf = JDOHelper.getPersistenceManagerFactory((String)factory);
        }
        catch (JDOException ex) {
            LOGGER_REST.error((Object)ex.getMessage(), (Throwable)ex);
            new ServletException((Throwable)ex);
        }
        super.init(config);
    }

    private String getClassName(HttpServletRequest req) {
        String path = req.getRequestURI().substring(req.getContextPath().length() + req.getServletPath().length());
        StringTokenizer tokenizer = new StringTokenizer(path, "/");
        return tokenizer.nextToken();
    }

    private Object getId(HttpServletRequest req) {
        OMFContext ctx = ((JDOPersistenceManagerFactory)this.pmf).getOMFContext();
        ClassLoaderResolver clr = ctx.getClassLoaderResolver((class$org$datanucleus$rest$RestServlet == null ? (class$org$datanucleus$rest$RestServlet = RestServlet.class$("org.datanucleus.rest.RestServlet")) : class$org$datanucleus$rest$RestServlet).getClassLoader());
        String path = req.getRequestURI().substring(req.getContextPath().length() + req.getServletPath().length());
        StringTokenizer tokenizer = new StringTokenizer(path, "/");
        String className = tokenizer.nextToken();
        String id = null;
        if (tokenizer.hasMoreTokens()) {
            id = tokenizer.nextToken();
            if (id == null) {
                return null;
            }
            AbstractClassMetaData cmd = ctx.getMetaDataManager().getMetaDataForClass(className, clr);
            if (cmd != null && cmd.usesSingleFieldIdentityClass()) {
                Object value = TypeConversionHelper.convertTo((Object)id, (Class)cmd.getMetaDataForMemberAtRelativePosition(cmd.getPKMemberPositions()[0]).getType());
                return this.getObject(value, clr.classForName(cmd.getObjectidClass()), clr.classForName(cmd.getFullClassName()), cmd);
            }
        }
        try {
            if (id == null && req.getContentLength() > 0) {
                char[] buffer = new char[req.getContentLength()];
                req.getReader().read(buffer);
                id = new String(buffer);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (id == null) {
            return null;
        }
        try {
            id = URLDecoder.decode(id, "UTF-8");
            JSONObject jsonobj = new JSONObject(id);
            return this.getObject(jsonobj, clr.classForName(jsonobj.getString("class")));
        }
        catch (JSONException ex) {
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        OMFContext ctx = ((JDOPersistenceManagerFactory)this.pmf).getOMFContext();
        try {
            String className = this.getClassName(req);
            ClassLoaderResolver clr = ctx.getClassLoaderResolver((class$org$datanucleus$rest$RestServlet == null ? (class$org$datanucleus$rest$RestServlet = RestServlet.class$("org.datanucleus.rest.RestServlet")) : class$org$datanucleus$rest$RestServlet).getClassLoader());
            AbstractClassMetaData cmd = ctx.getMetaDataManager().getMetaDataForEntityName(className);
            Class cls = null;
            try {
                if (cmd != null) {
                    className = cmd.getFullClassName();
                    cls = clr.classForName(className, true);
                } else {
                    cls = clr.classForName(className, true);
                    cmd = ctx.getMetaDataManager().getMetaDataForClass(cls, clr);
                }
            }
            catch (ClassNotResolvedException ex) {
                JSONObject error = new JSONObject();
                error.put("exception", ex.getMessage());
                resp.getWriter().write(error.toString());
                resp.setStatus(404);
                resp.setHeader("Content-Type", "application/json");
                return;
            }
            Object id = this.getId(req);
            if (id == null) {
                try {
                    String queryString = "SELECT FROM " + cls.getName();
                    if (req.getQueryString() != null) {
                        queryString = queryString + " WHERE " + URLDecoder.decode(req.getQueryString(), "UTF-8");
                    }
                    PersistenceManager pm = this.pmf.getPersistenceManager();
                    try {
                        pm.currentTransaction().begin();
                        Query query = pm.newQuery(queryString);
                        Object result = query.execute();
                        JSONSerializer serializer = new JSONSerializer();
                        resp.getWriter().write(serializer.deepSerialize(result));
                        resp.setHeader("Content-Type", "application/json");
                        resp.setStatus(200);
                        pm.currentTransaction().commit();
                    }
                    finally {
                        if (pm.currentTransaction().isActive()) {
                            pm.currentTransaction().rollback();
                        }
                        pm.close();
                    }
                    return;
                }
                catch (JDOFatalUserException e) {
                    JSONObject error = new JSONObject();
                    error.put("exception", e.getMessage());
                    resp.getWriter().write(error.toString());
                    resp.setStatus(400);
                    resp.setHeader("Content-Type", "application/json");
                    return;
                }
                catch (JDOException ex) {
                    JSONObject error = new JSONObject();
                    error.put("exception", ex.getMessage());
                    resp.getWriter().write(error.toString());
                    resp.setStatus(404);
                    resp.setHeader("Content-Type", "application/json");
                    return;
                }
                catch (RuntimeException ex) {
                    ex.printStackTrace();
                    JSONObject error = new JSONObject();
                    error.put("exception", ex.getMessage());
                    resp.getWriter().write(error.toString());
                    resp.setStatus(404);
                    resp.setHeader("Content-Type", "application/json");
                    return;
                }
            }
            if (cmd.getIdentityType() != IdentityType.APPLICATION) {
                JSONObject error = new JSONObject();
                error.put("exception", "Only application identity types are support.");
                resp.getWriter().write(error.toString());
                resp.setStatus(404);
                resp.setHeader("Content-Type", "application/json");
                return;
            }
            PersistenceManager pm = this.pmf.getPersistenceManager();
            try {
                pm.currentTransaction().begin();
                Object result = pm.getObjectById(id);
                JSONSerializer serializer = new JSONSerializer();
                resp.getWriter().write(serializer.deepSerialize(result));
                resp.setHeader("Content-Type", "application/json");
                pm.currentTransaction().commit();
                return;
            }
            catch (JDOObjectNotFoundException ex) {
                resp.setContentLength(0);
                resp.setStatus(404);
                return;
            }
            catch (JDOException ex) {
                JSONObject error = new JSONObject();
                error.put("exception", ex.getMessage());
                resp.getWriter().write(error.toString());
                resp.setStatus(404);
                resp.setHeader("Content-Type", "application/json");
                return;
            }
            finally {
                if (pm.currentTransaction().isActive()) {
                    pm.currentTransaction().rollback();
                }
                pm.close();
            }
        }
        catch (JSONException e) {
            try {
                JSONObject error = new JSONObject();
                error.put("exception", e.getMessage());
                resp.getWriter().write(error.toString());
                resp.setStatus(404);
                resp.setHeader("Content-Type", "application/json");
            }
            catch (JSONException e1) {
                // empty catch block
            }
            return;
        }
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.addHeader("Allow", " GET, HEAD, POST, PUT, TRACE, OPTIONS");
        resp.setContentLength(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doHead(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        OMFContext ctx = ((JDOPersistenceManagerFactory)this.pmf).getOMFContext();
        String className = this.getClassName(req);
        ClassLoaderResolver clr = ctx.getClassLoaderResolver((class$org$datanucleus$rest$RestServlet == null ? (class$org$datanucleus$rest$RestServlet = RestServlet.class$("org.datanucleus.rest.RestServlet")) : class$org$datanucleus$rest$RestServlet).getClassLoader());
        AbstractClassMetaData cmd = ctx.getMetaDataManager().getMetaDataForEntityName(className);
        Class cls = null;
        try {
            if (cmd != null) {
                className = cmd.getFullClassName();
                cls = clr.classForName(className, true);
            } else {
                cls = clr.classForName(className, true);
                cmd = ctx.getMetaDataManager().getMetaDataForClass(cls, clr);
            }
        }
        catch (ClassNotResolvedException ex) {
            resp.setStatus(404);
            return;
        }
        Object id = this.getId(req);
        if (id == null) {
            try {
                String queryString = "SELECT FROM " + cls.getName();
                if (req.getQueryString() != null) {
                    queryString = queryString + " WHERE " + URLDecoder.decode(req.getQueryString(), "UTF-8");
                }
                PersistenceManager pm = this.pmf.getPersistenceManager();
                try {
                    pm.currentTransaction().begin();
                    Query query = pm.newQuery(queryString);
                    query.execute();
                    resp.setStatus(200);
                    pm.currentTransaction().commit();
                }
                finally {
                    if (pm.currentTransaction().isActive()) {
                        pm.currentTransaction().rollback();
                    }
                    pm.close();
                }
                return;
            }
            catch (JDOFatalUserException e) {
                resp.setStatus(400);
                return;
            }
            catch (JDOException ex) {
                resp.setStatus(404);
                return;
            }
            catch (RuntimeException ex) {
                resp.setStatus(404);
                return;
            }
        }
        if (cmd.getIdentityType() != IdentityType.APPLICATION) {
            resp.setStatus(404);
            return;
        }
        PersistenceManager pm = this.pmf.getPersistenceManager();
        try {
            pm.currentTransaction().begin();
            pm.getObjectById(id);
            resp.setStatus(200);
            pm.currentTransaction().commit();
            return;
        }
        catch (JDOException ex) {
            resp.setStatus(404);
            return;
        }
        finally {
            if (pm.currentTransaction().isActive()) {
                pm.currentTransaction().rollback();
            }
            pm.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (req.getContentLength() < 1) {
            resp.setContentLength(0);
            resp.setStatus(400);
            return;
        }
        char[] buffer = new char[req.getContentLength()];
        req.getReader().read(buffer);
        String str = new String(buffer);
        PersistenceManager pm = this.pmf.getPersistenceManager();
        try {
            pm.currentTransaction().begin();
            JSONObject jsonobj = new JSONObject(str);
            String className = this.getClassName(req);
            Object obj = pm.makePersistent(this.getObjectFromJSONOject(jsonobj, className, pm));
            JSONSerializer serializer = new JSONSerializer();
            resp.getWriter().write(serializer.deepSerialize(obj));
            resp.setHeader("Content-Type", "application/json");
            pm.currentTransaction().commit();
        }
        catch (ClassNotResolvedException e) {
            try {
                JSONObject error = new JSONObject();
                error.put("exception", e.getMessage());
                resp.getWriter().write(error.toString());
                resp.setStatus(500);
                resp.setHeader("Content-Type", "application/json");
                LOGGER_REST.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (JSONException e1) {
                throw new RuntimeException(e1);
            }
        }
        catch (JDOFatalUserException e) {
            try {
                JSONObject error = new JSONObject();
                error.put("exception", e.getMessage());
                resp.getWriter().write(error.toString());
                resp.setStatus(400);
                resp.setHeader("Content-Type", "application/json");
                LOGGER_REST.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (JSONException e1) {
                throw new RuntimeException(e1);
            }
        }
        catch (JDOException e) {
            try {
                JSONObject error = new JSONObject();
                error.put("exception", e.getMessage());
                resp.getWriter().write(error.toString());
                resp.setStatus(500);
                resp.setHeader("Content-Type", "application/json");
                LOGGER_REST.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (JSONException e1) {
                throw new RuntimeException(e1);
            }
        }
        catch (JSONException e) {
            try {
                JSONObject error = new JSONObject();
                error.put("exception", e.getMessage());
                resp.getWriter().write(error.toString());
                resp.setStatus(500);
                resp.setHeader("Content-Type", "application/json");
                LOGGER_REST.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (JSONException e1) {
                throw new RuntimeException(e1);
            }
        }
        finally {
            if (pm.currentTransaction().isActive()) {
                pm.currentTransaction().rollback();
            }
            pm.close();
        }
        resp.setStatus(201);
    }

    /*
     * Exception decompiling
     */
    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 9 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected Object getObjectFromJSONOject(JSONObject jsonobj, String className, PersistenceManager pm) {
        OMFContext ctx = ((JDOPersistenceManager)pm).getObjectManager().getOMFContext();
        ClassLoaderResolver clr = ctx.getClassLoaderResolver((class$org$datanucleus$rest$RestServlet == null ? (class$org$datanucleus$rest$RestServlet = RestServlet.class$("org.datanucleus.rest.RestServlet")) : class$org$datanucleus$rest$RestServlet).getClassLoader());
        AbstractClassMetaData cmd = ctx.getMetaDataManager().getMetaDataForEntityName(className);
        Class cls = null;
        if (cmd != null) {
            className = cmd.getFullClassName();
            cls = clr.classForName(className, true);
        } else {
            cls = clr.classForName(className, true);
            cmd = ctx.getMetaDataManager().getMetaDataForClass(cls, clr);
        }
        ExecutionContext ec = ((JDOPersistenceManager)pm).getObjectManager().getExecutionContext();
        if (cmd == null) {
            return this.getObject(jsonobj, cls);
        }
        LocalSM sm1 = null;
        sm1 = new LocalSM(cls);
        int[] fieldNumbers = cmd.getAllMemberPositions();
        sm1.replaceFields(fieldNumbers, new LocalFieldManager(jsonobj, null, cmd, pm));
        Object obj = sm1.getObject();
        try {
            Object id = ec.getApiAdapter().getNewApplicationIdentityObjectId(sm1.getObject(), cmd);
            obj = pm.getObjectById(id);
            ObjectProvider sm = ec.findObjectProvider(obj);
            fieldNumbers = cmd.getNonPKMemberPositions();
            sm.replaceFields(fieldNumbers, (FieldManager)new LocalFieldManager(jsonobj, sm, cmd, pm));
            return obj;
        }
        catch (JDONullIdentityException ex) {
            sm1.disconnect();
            return obj;
        }
        catch (JDOObjectNotFoundException ex) {
            sm1.disconnect();
            return obj;
        }
    }

    private Object getObject(Object field, Class cls, Class pcType, AbstractClassMetaData cmd) {
        OMFContext ctx = ((JDOPersistenceManagerFactory)this.pmf).getOMFContext();
        return ctx.getApiAdapter().getNewSingleFieldIdentity(cls, pcType, field);
    }

    private Object getObject(final JSONObject jsonobj, final Class cls) {
        if (cls.getName().equals("com.google.appengine.api.users.User")) {
            String email = null;
            String authDomain = null;
            try {
                email = jsonobj.getString("email");
            }
            catch (JSONException e) {
                // empty catch block
            }
            try {
                authDomain = jsonobj.getString("authDomain");
            }
            catch (JSONException e) {
                // empty catch block
            }
            return ClassUtils.newInstance((Class)cls, (Class[])new Class[]{class$java$lang$String == null ? (class$java$lang$String = RestServlet.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = RestServlet.class$("java.lang.String")) : class$java$lang$String}, (Object[])new String[]{email, authDomain});
        }
        if (cls.getName().equals("com.google.appengine.api.datastore.Key")) {
            try {
                Object parent = null;
                if (jsonobj.has("parent") && !jsonobj.isNull("parent")) {
                    OMFContext ctx = ((JDOPersistenceManagerFactory)this.pmf).getOMFContext();
                    ClassLoaderResolver clr = ctx.getClassLoaderResolver((class$org$datanucleus$rest$RestServlet == null ? (class$org$datanucleus$rest$RestServlet = RestServlet.class$("org.datanucleus.rest.RestServlet")) : class$org$datanucleus$rest$RestServlet).getClassLoader());
                    JSONObject parentobj = jsonobj.getJSONObject("parent");
                    parent = this.getObject(parentobj, clr.classForName(jsonobj.getString("class")));
                }
                if (jsonobj.has("appId")) {
                    String appId = jsonobj.getString("appId");
                    String kind = jsonobj.getString("kind");
                    Class<?> keyFactory = Class.forName("com.google.appengine.api.datastore.KeyFactory", false, cls.getClassLoader());
                    if (parent != null) {
                        return ClassUtils.getMethodForClass(keyFactory, (String)"createKey", (Class[])new Class[]{cls, class$java$lang$String == null ? (class$java$lang$String = RestServlet.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = RestServlet.class$("java.lang.String")) : class$java$lang$String}).invoke(null, parent, kind, appId);
                    }
                    return ClassUtils.getMethodForClass(keyFactory, (String)"createKey", (Class[])new Class[]{class$java$lang$String == null ? (class$java$lang$String = RestServlet.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = RestServlet.class$("java.lang.String")) : class$java$lang$String}).invoke(null, kind, appId);
                }
                long id = jsonobj.getLong("id");
                String kind = jsonobj.getString("kind");
                Class<?> keyFactory = Class.forName("com.google.appengine.api.datastore.KeyFactory", false, cls.getClassLoader());
                if (parent != null) {
                    return ClassUtils.getMethodForClass(keyFactory, (String)"createKey", (Class[])new Class[]{cls, class$java$lang$String == null ? (class$java$lang$String = RestServlet.class$("java.lang.String")) : class$java$lang$String, Long.TYPE}).invoke(null, parent, kind, id);
                }
                return ClassUtils.getMethodForClass(keyFactory, (String)"createKey", (Class[])new Class[]{class$java$lang$String == null ? (class$java$lang$String = RestServlet.class$("java.lang.String")) : class$java$lang$String, Long.TYPE}).invoke(null, kind, id);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        try {
            return AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        Constructor c = ClassUtils.getConstructorWithArguments((Class)cls, (Class[])new Class[0]);
                        ((AccessibleObject)c).setAccessible(true);
                        Object obj = c.newInstance(new Object[0]);
                        String[] fieldNames = JSONObject.getNames(jsonobj);
                        for (int i = 0; i < jsonobj.length(); ++i) {
                            if (fieldNames[i].equals("class")) continue;
                            Field field = cls.getField(fieldNames[i]);
                            ((AccessibleObject)field).setAccessible(true);
                            field.set(obj, jsonobj.get(fieldNames[i]));
                        }
                        return obj;
                    }
                    catch (InstantiationException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                    catch (SecurityException e) {
                        e.printStackTrace();
                    }
                    catch (NoSuchFieldException e) {
                        e.printStackTrace();
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                    return null;
                }
            });
        }
        catch (SecurityException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class LocalSM
    implements StateManager {
        PersistenceCapable myPC;
        FieldManager fm;

        public LocalSM(Class cls) {
            this.myPC = JDOImplHelper.getInstance().newInstance(cls, (StateManager)this);
        }

        public boolean getBooleanField(PersistenceCapable arg0, int arg1, boolean arg2) {
            return false;
        }

        public byte getByteField(PersistenceCapable arg0, int arg1, byte arg2) {
            return 0;
        }

        public char getCharField(PersistenceCapable arg0, int arg1, char arg2) {
            return '\u0000';
        }

        public double getDoubleField(PersistenceCapable arg0, int arg1, double arg2) {
            return 0.0;
        }

        public float getFloatField(PersistenceCapable arg0, int arg1, float arg2) {
            return 0.0f;
        }

        public int getIntField(PersistenceCapable arg0, int arg1, int arg2) {
            return 0;
        }

        public long getLongField(PersistenceCapable arg0, int arg1, long arg2) {
            return 0L;
        }

        public Object getObjectField(PersistenceCapable arg0, int arg1, Object arg2) {
            return null;
        }

        public Object getObjectId(PersistenceCapable arg0) {
            return null;
        }

        public PersistenceManager getPersistenceManager(PersistenceCapable arg0) {
            return null;
        }

        public short getShortField(PersistenceCapable arg0, int arg1, short arg2) {
            return 0;
        }

        public String getStringField(PersistenceCapable arg0, int arg1, String arg2) {
            return null;
        }

        public Object getTransactionalObjectId(PersistenceCapable arg0) {
            return null;
        }

        public Object getVersion(PersistenceCapable arg0) {
            return null;
        }

        public boolean isDeleted(PersistenceCapable arg0) {
            return false;
        }

        public boolean isDirty(PersistenceCapable arg0) {
            return false;
        }

        public boolean isLoaded(PersistenceCapable arg0, int arg1) {
            return false;
        }

        public boolean isNew(PersistenceCapable arg0) {
            return false;
        }

        public boolean isPersistent(PersistenceCapable arg0) {
            return false;
        }

        public boolean isTransactional(PersistenceCapable arg0) {
            return false;
        }

        public void makeDirty(PersistenceCapable arg0, String arg1) {
        }

        public void preSerialize(PersistenceCapable arg0) {
        }

        public void providedBooleanField(PersistenceCapable arg0, int arg1, boolean arg2) {
        }

        public void providedByteField(PersistenceCapable arg0, int arg1, byte arg2) {
        }

        public void providedCharField(PersistenceCapable arg0, int arg1, char arg2) {
        }

        public void providedDoubleField(PersistenceCapable arg0, int arg1, double arg2) {
        }

        public void providedFloatField(PersistenceCapable arg0, int arg1, float arg2) {
        }

        public void providedIntField(PersistenceCapable arg0, int arg1, int arg2) {
        }

        public void providedLongField(PersistenceCapable arg0, int arg1, long arg2) {
        }

        public void providedObjectField(PersistenceCapable arg0, int arg1, Object arg2) {
        }

        public void providedShortField(PersistenceCapable arg0, int arg1, short arg2) {
        }

        public void providedStringField(PersistenceCapable arg0, int arg1, String arg2) {
        }

        public boolean replacingBooleanField(PersistenceCapable arg0, int arg1) {
            return this.fm.fetchBooleanField(arg1);
        }

        public byte replacingByteField(PersistenceCapable arg0, int arg1) {
            return this.fm.fetchByteField(arg1);
        }

        public char replacingCharField(PersistenceCapable arg0, int arg1) {
            return this.fm.fetchCharField(arg1);
        }

        public Object[] replacingDetachedState(Detachable arg0, Object[] arg1) {
            return null;
        }

        public double replacingDoubleField(PersistenceCapable arg0, int arg1) {
            return this.fm.fetchDoubleField(arg1);
        }

        public byte replacingFlags(PersistenceCapable arg0) {
            return 0;
        }

        public float replacingFloatField(PersistenceCapable arg0, int arg1) {
            return this.fm.fetchFloatField(arg1);
        }

        public int replacingIntField(PersistenceCapable arg0, int arg1) {
            return this.fm.fetchIntField(arg1);
        }

        public long replacingLongField(PersistenceCapable arg0, int arg1) {
            return this.fm.fetchLongField(arg1);
        }

        public Object replacingObjectField(PersistenceCapable arg0, int arg1) {
            return this.fm.fetchObjectField(arg1);
        }

        public short replacingShortField(PersistenceCapable arg0, int arg1) {
            return this.fm.fetchShortField(arg1);
        }

        public StateManager replacingStateManager(PersistenceCapable arg0, StateManager arg1) {
            return null;
        }

        public String replacingStringField(PersistenceCapable arg0, int arg1) {
            return this.fm.fetchStringField(arg1);
        }

        public void setBooleanField(PersistenceCapable arg0, int arg1, boolean arg2, boolean arg3) {
        }

        public void setByteField(PersistenceCapable arg0, int arg1, byte arg2, byte arg3) {
        }

        public void setCharField(PersistenceCapable arg0, int arg1, char arg2, char arg3) {
        }

        public void setDoubleField(PersistenceCapable arg0, int arg1, double arg2, double arg3) {
        }

        public void setFloatField(PersistenceCapable arg0, int arg1, float arg2, float arg3) {
        }

        public void setIntField(PersistenceCapable arg0, int arg1, int arg2, int arg3) {
        }

        public void setLongField(PersistenceCapable arg0, int arg1, long arg2, long arg3) {
        }

        public void setObjectField(PersistenceCapable arg0, int arg1, Object arg2, Object arg3) {
        }

        public void setShortField(PersistenceCapable arg0, int arg1, short arg2, short arg3) {
        }

        public void setStringField(PersistenceCapable arg0, int arg1, String arg2, String arg3) {
        }

        void replaceFields(int[] fieldNumbers, FieldManager fm) {
            this.fm = fm;
            this.myPC.jdoReplaceFields(fieldNumbers);
        }

        public Object getObject() {
            return this.myPC;
        }

        public void disconnect() {
            try {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        LocalSM.this.myPC.jdoReplaceStateManager(null);
                        return null;
                    }
                });
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }

    class LocalFieldManager
    implements FieldManager {
        JSONObject jsonobj;
        AbstractClassMetaData cmd;
        ObjectProvider sm;
        PersistenceManager pm;

        LocalFieldManager(JSONObject jsonobj, ObjectProvider sm, AbstractClassMetaData cmd, PersistenceManager pm) {
            this.jsonobj = jsonobj;
            this.cmd = cmd;
            this.sm = sm;
            this.pm = pm;
        }

        public String fetchStringField(int position) {
            String fieldName = this.cmd.getMetaDataForMemberAtRelativePosition(position).getName();
            if (!this.jsonobj.has(fieldName)) {
                return null;
            }
            try {
                String value = this.jsonobj.getString(fieldName);
                if (this.sm != null) {
                    this.sm.makeDirty(position);
                }
                return value;
            }
            catch (JSONException jSONException) {
                return null;
            }
        }

        public short fetchShortField(int position) {
            String fieldName = this.cmd.getMetaDataForMemberAtRelativePosition(position).getName();
            if (!this.jsonobj.has(fieldName)) {
                return 0;
            }
            try {
                short value = (short)this.jsonobj.getInt(fieldName);
                if (this.sm != null) {
                    this.sm.makeDirty(position);
                }
                return value;
            }
            catch (JSONException jSONException) {
                return 0;
            }
        }

        public Object fetchObjectField(int position) {
            String fieldName = this.cmd.getMetaDataForMemberAtRelativePosition(position).getName();
            if (!this.jsonobj.has(fieldName)) {
                return null;
            }
            try {
                if (this.jsonobj.isNull(fieldName)) {
                    return null;
                }
                Object value = this.jsonobj.get(fieldName);
                if (value instanceof JSONObject) {
                    value = RestServlet.this.getObjectFromJSONOject((JSONObject)value, ((JSONObject)value).getString("class"), this.pm);
                    if (this.sm != null) {
                        this.sm.makeDirty(position);
                    }
                    return value;
                }
                if (value instanceof JSONArray) {
                    value = this.fetchJSONArray((JSONArray)value, position);
                    if (this.sm != null) {
                        this.sm.makeDirty(position);
                    }
                    return value;
                }
                if (this.sm != null) {
                    this.sm.makeDirty(position);
                }
                return TypeConversionHelper.convertTo((Object)value, (Class)this.cmd.getMetaDataForMemberAtRelativePosition(position).getType());
            }
            catch (JSONException ex) {
                throw new RuntimeException(ex);
            }
        }

        private List fetchJSONArray(JSONArray array, int position) throws JSONException {
            ArrayList<Object> elements = new ArrayList<Object>();
            for (int i = 0; i < array.length(); ++i) {
                if (array.isNull(i)) {
                    elements.add(null);
                    continue;
                }
                Object value = array.get(i);
                if (value instanceof JSONObject) {
                    elements.add(RestServlet.this.getObjectFromJSONOject((JSONObject)value, ((JSONObject)value).getString("class"), this.pm));
                    continue;
                }
                if (value instanceof JSONArray) {
                    elements.add(this.fetchJSONArray((JSONArray)value, position));
                    continue;
                }
                elements.add(TypeConversionHelper.convertTo((Object)value, (Class)this.cmd.getMetaDataForMemberAtRelativePosition(position).getType()));
            }
            return elements;
        }

        public long fetchLongField(int position) {
            String fieldName = this.cmd.getMetaDataForMemberAtRelativePosition(position).getName();
            if (!this.jsonobj.has(fieldName)) {
                return 0L;
            }
            try {
                long value = this.jsonobj.getLong(fieldName);
                if (this.sm != null) {
                    this.sm.makeDirty(position);
                }
                return value;
            }
            catch (JSONException jSONException) {
                return 0L;
            }
        }

        public int fetchIntField(int position) {
            String fieldName = this.cmd.getMetaDataForMemberAtRelativePosition(position).getName();
            if (!this.jsonobj.has(fieldName)) {
                return 0;
            }
            try {
                int value = this.jsonobj.getInt(fieldName);
                if (this.sm != null) {
                    this.sm.makeDirty(position);
                }
                return value;
            }
            catch (JSONException jSONException) {
                return 0;
            }
        }

        public float fetchFloatField(int position) {
            String fieldName = this.cmd.getMetaDataForMemberAtRelativePosition(position).getName();
            if (!this.jsonobj.has(fieldName)) {
                return 0.0f;
            }
            try {
                float value = (float)this.jsonobj.getDouble(fieldName);
                if (this.sm != null) {
                    this.sm.makeDirty(position);
                }
                return value;
            }
            catch (JSONException jSONException) {
                return 0.0f;
            }
        }

        public double fetchDoubleField(int position) {
            String fieldName = this.cmd.getMetaDataForMemberAtRelativePosition(position).getName();
            if (!this.jsonobj.has(fieldName)) {
                return 0.0;
            }
            try {
                double value = this.jsonobj.getDouble(fieldName);
                if (this.sm != null) {
                    this.sm.makeDirty(position);
                }
                return value;
            }
            catch (JSONException jSONException) {
                return 0.0;
            }
        }

        public char fetchCharField(int position) {
            String fieldName = this.cmd.getMetaDataForMemberAtRelativePosition(position).getName();
            if (!this.jsonobj.has(fieldName)) {
                return '\u0000';
            }
            try {
                String str = this.jsonobj.getString(fieldName);
                char value = '\u0000';
                if (str != null && str.length() > 0) {
                    value = str.charAt(0);
                }
                if (this.sm != null) {
                    this.sm.makeDirty(position);
                }
                return value;
            }
            catch (JSONException jSONException) {
                return '\u0000';
            }
        }

        public byte fetchByteField(int position) {
            String fieldName = this.cmd.getMetaDataForMemberAtRelativePosition(position).getName();
            if (!this.jsonobj.has(fieldName)) {
                return 0;
            }
            try {
                String str = this.jsonobj.getString(fieldName);
                byte value = 0;
                if (str != null && str.length() > 0) {
                    value = str.getBytes()[0];
                }
                if (this.sm != null) {
                    this.sm.makeDirty(position);
                }
                return value;
            }
            catch (JSONException jSONException) {
                return 0;
            }
        }

        public boolean fetchBooleanField(int position) {
            String fieldName = this.cmd.getMetaDataForMemberAtRelativePosition(position).getName();
            if (!this.jsonobj.has(fieldName)) {
                return false;
            }
            try {
                boolean value = this.jsonobj.getBoolean(fieldName);
                if (this.sm != null) {
                    this.sm.makeDirty(position);
                }
                return value;
            }
            catch (JSONException e) {
                e.printStackTrace();
                return false;
            }
        }

        public void storeStringField(int arg0, String arg1) {
        }

        public void storeShortField(int arg0, short arg1) {
        }

        public void storeObjectField(int arg0, Object arg1) {
        }

        public void storeLongField(int arg0, long arg1) {
        }

        public void storeIntField(int arg0, int arg1) {
        }

        public void storeFloatField(int arg0, float arg1) {
        }

        public void storeDoubleField(int arg0, double arg1) {
        }

        public void storeCharField(int arg0, char arg1) {
        }

        public void storeByteField(int arg0, byte arg1) {
        }

        public void storeBooleanField(int arg0, boolean arg1) {
        }
    }
}

