/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.codedeploy.model.EC2TagFilter;
import com.amazonaws.services.codedeploy.model.TagFilter;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class UpdateDeploymentGroupRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String applicationName;
    private String currentDeploymentGroupName;
    private String newDeploymentGroupName;
    private String deploymentConfigName;
    private SdkInternalList<EC2TagFilter> ec2TagFilters;
    private SdkInternalList<TagFilter> onPremisesInstanceTagFilters;
    private SdkInternalList<String> autoScalingGroups;
    private String serviceRoleArn;

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public UpdateDeploymentGroupRequest withApplicationName(String applicationName) {
        this.setApplicationName(applicationName);
        return this;
    }

    public void setCurrentDeploymentGroupName(String currentDeploymentGroupName) {
        this.currentDeploymentGroupName = currentDeploymentGroupName;
    }

    public String getCurrentDeploymentGroupName() {
        return this.currentDeploymentGroupName;
    }

    public UpdateDeploymentGroupRequest withCurrentDeploymentGroupName(String currentDeploymentGroupName) {
        this.setCurrentDeploymentGroupName(currentDeploymentGroupName);
        return this;
    }

    public void setNewDeploymentGroupName(String newDeploymentGroupName) {
        this.newDeploymentGroupName = newDeploymentGroupName;
    }

    public String getNewDeploymentGroupName() {
        return this.newDeploymentGroupName;
    }

    public UpdateDeploymentGroupRequest withNewDeploymentGroupName(String newDeploymentGroupName) {
        this.setNewDeploymentGroupName(newDeploymentGroupName);
        return this;
    }

    public void setDeploymentConfigName(String deploymentConfigName) {
        this.deploymentConfigName = deploymentConfigName;
    }

    public String getDeploymentConfigName() {
        return this.deploymentConfigName;
    }

    public UpdateDeploymentGroupRequest withDeploymentConfigName(String deploymentConfigName) {
        this.setDeploymentConfigName(deploymentConfigName);
        return this;
    }

    public List<EC2TagFilter> getEc2TagFilters() {
        if (this.ec2TagFilters == null) {
            this.ec2TagFilters = new SdkInternalList();
        }
        return this.ec2TagFilters;
    }

    public void setEc2TagFilters(Collection<EC2TagFilter> ec2TagFilters) {
        if (ec2TagFilters == null) {
            this.ec2TagFilters = null;
            return;
        }
        this.ec2TagFilters = new SdkInternalList<EC2TagFilter>(ec2TagFilters);
    }

    public UpdateDeploymentGroupRequest withEc2TagFilters(EC2TagFilter ... ec2TagFilters) {
        if (this.ec2TagFilters == null) {
            this.setEc2TagFilters(new SdkInternalList<EC2TagFilter>(ec2TagFilters.length));
        }
        for (EC2TagFilter ele : ec2TagFilters) {
            this.ec2TagFilters.add(ele);
        }
        return this;
    }

    public UpdateDeploymentGroupRequest withEc2TagFilters(Collection<EC2TagFilter> ec2TagFilters) {
        this.setEc2TagFilters(ec2TagFilters);
        return this;
    }

    public List<TagFilter> getOnPremisesInstanceTagFilters() {
        if (this.onPremisesInstanceTagFilters == null) {
            this.onPremisesInstanceTagFilters = new SdkInternalList();
        }
        return this.onPremisesInstanceTagFilters;
    }

    public void setOnPremisesInstanceTagFilters(Collection<TagFilter> onPremisesInstanceTagFilters) {
        if (onPremisesInstanceTagFilters == null) {
            this.onPremisesInstanceTagFilters = null;
            return;
        }
        this.onPremisesInstanceTagFilters = new SdkInternalList<TagFilter>(onPremisesInstanceTagFilters);
    }

    public UpdateDeploymentGroupRequest withOnPremisesInstanceTagFilters(TagFilter ... onPremisesInstanceTagFilters) {
        if (this.onPremisesInstanceTagFilters == null) {
            this.setOnPremisesInstanceTagFilters(new SdkInternalList<TagFilter>(onPremisesInstanceTagFilters.length));
        }
        for (TagFilter ele : onPremisesInstanceTagFilters) {
            this.onPremisesInstanceTagFilters.add(ele);
        }
        return this;
    }

    public UpdateDeploymentGroupRequest withOnPremisesInstanceTagFilters(Collection<TagFilter> onPremisesInstanceTagFilters) {
        this.setOnPremisesInstanceTagFilters(onPremisesInstanceTagFilters);
        return this;
    }

    public List<String> getAutoScalingGroups() {
        if (this.autoScalingGroups == null) {
            this.autoScalingGroups = new SdkInternalList();
        }
        return this.autoScalingGroups;
    }

    public void setAutoScalingGroups(Collection<String> autoScalingGroups) {
        if (autoScalingGroups == null) {
            this.autoScalingGroups = null;
            return;
        }
        this.autoScalingGroups = new SdkInternalList<String>(autoScalingGroups);
    }

    public UpdateDeploymentGroupRequest withAutoScalingGroups(String ... autoScalingGroups) {
        if (this.autoScalingGroups == null) {
            this.setAutoScalingGroups(new SdkInternalList<String>(autoScalingGroups.length));
        }
        for (String ele : autoScalingGroups) {
            this.autoScalingGroups.add(ele);
        }
        return this;
    }

    public UpdateDeploymentGroupRequest withAutoScalingGroups(Collection<String> autoScalingGroups) {
        this.setAutoScalingGroups(autoScalingGroups);
        return this;
    }

    public void setServiceRoleArn(String serviceRoleArn) {
        this.serviceRoleArn = serviceRoleArn;
    }

    public String getServiceRoleArn() {
        return this.serviceRoleArn;
    }

    public UpdateDeploymentGroupRequest withServiceRoleArn(String serviceRoleArn) {
        this.setServiceRoleArn(serviceRoleArn);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getApplicationName() != null) {
            sb.append("ApplicationName: " + this.getApplicationName() + ",");
        }
        if (this.getCurrentDeploymentGroupName() != null) {
            sb.append("CurrentDeploymentGroupName: " + this.getCurrentDeploymentGroupName() + ",");
        }
        if (this.getNewDeploymentGroupName() != null) {
            sb.append("NewDeploymentGroupName: " + this.getNewDeploymentGroupName() + ",");
        }
        if (this.getDeploymentConfigName() != null) {
            sb.append("DeploymentConfigName: " + this.getDeploymentConfigName() + ",");
        }
        if (this.getEc2TagFilters() != null) {
            sb.append("Ec2TagFilters: " + this.getEc2TagFilters() + ",");
        }
        if (this.getOnPremisesInstanceTagFilters() != null) {
            sb.append("OnPremisesInstanceTagFilters: " + this.getOnPremisesInstanceTagFilters() + ",");
        }
        if (this.getAutoScalingGroups() != null) {
            sb.append("AutoScalingGroups: " + this.getAutoScalingGroups() + ",");
        }
        if (this.getServiceRoleArn() != null) {
            sb.append("ServiceRoleArn: " + this.getServiceRoleArn());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDeploymentGroupRequest)) {
            return false;
        }
        UpdateDeploymentGroupRequest other = (UpdateDeploymentGroupRequest)obj;
        if (other.getApplicationName() == null ^ this.getApplicationName() == null) {
            return false;
        }
        if (other.getApplicationName() != null && !other.getApplicationName().equals(this.getApplicationName())) {
            return false;
        }
        if (other.getCurrentDeploymentGroupName() == null ^ this.getCurrentDeploymentGroupName() == null) {
            return false;
        }
        if (other.getCurrentDeploymentGroupName() != null && !other.getCurrentDeploymentGroupName().equals(this.getCurrentDeploymentGroupName())) {
            return false;
        }
        if (other.getNewDeploymentGroupName() == null ^ this.getNewDeploymentGroupName() == null) {
            return false;
        }
        if (other.getNewDeploymentGroupName() != null && !other.getNewDeploymentGroupName().equals(this.getNewDeploymentGroupName())) {
            return false;
        }
        if (other.getDeploymentConfigName() == null ^ this.getDeploymentConfigName() == null) {
            return false;
        }
        if (other.getDeploymentConfigName() != null && !other.getDeploymentConfigName().equals(this.getDeploymentConfigName())) {
            return false;
        }
        if (other.getEc2TagFilters() == null ^ this.getEc2TagFilters() == null) {
            return false;
        }
        if (other.getEc2TagFilters() != null && !other.getEc2TagFilters().equals(this.getEc2TagFilters())) {
            return false;
        }
        if (other.getOnPremisesInstanceTagFilters() == null ^ this.getOnPremisesInstanceTagFilters() == null) {
            return false;
        }
        if (other.getOnPremisesInstanceTagFilters() != null && !other.getOnPremisesInstanceTagFilters().equals(this.getOnPremisesInstanceTagFilters())) {
            return false;
        }
        if (other.getAutoScalingGroups() == null ^ this.getAutoScalingGroups() == null) {
            return false;
        }
        if (other.getAutoScalingGroups() != null && !other.getAutoScalingGroups().equals(this.getAutoScalingGroups())) {
            return false;
        }
        if (other.getServiceRoleArn() == null ^ this.getServiceRoleArn() == null) {
            return false;
        }
        return other.getServiceRoleArn() == null || other.getServiceRoleArn().equals(this.getServiceRoleArn());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getApplicationName() == null ? 0 : this.getApplicationName().hashCode());
        hashCode = 31 * hashCode + (this.getCurrentDeploymentGroupName() == null ? 0 : this.getCurrentDeploymentGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getNewDeploymentGroupName() == null ? 0 : this.getNewDeploymentGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getDeploymentConfigName() == null ? 0 : this.getDeploymentConfigName().hashCode());
        hashCode = 31 * hashCode + (this.getEc2TagFilters() == null ? 0 : this.getEc2TagFilters().hashCode());
        hashCode = 31 * hashCode + (this.getOnPremisesInstanceTagFilters() == null ? 0 : this.getOnPremisesInstanceTagFilters().hashCode());
        hashCode = 31 * hashCode + (this.getAutoScalingGroups() == null ? 0 : this.getAutoScalingGroups().hashCode());
        hashCode = 31 * hashCode + (this.getServiceRoleArn() == null ? 0 : this.getServiceRoleArn().hashCode());
        return hashCode;
    }

    @Override
    public UpdateDeploymentGroupRequest clone() {
        return (UpdateDeploymentGroupRequest)super.clone();
    }
}

