/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.config.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.config.model.DeliveryChannel;
import com.amazonaws.services.config.model.PutDeliveryChannelRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class PutDeliveryChannelRequestMarshaller
implements Marshaller<Request<PutDeliveryChannelRequest>, PutDeliveryChannelRequest> {
    @Override
    public Request<PutDeliveryChannelRequest> marshall(PutDeliveryChannelRequest putDeliveryChannelRequest) {
        if (putDeliveryChannelRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<PutDeliveryChannelRequest> request = new DefaultRequest<PutDeliveryChannelRequest>(putDeliveryChannelRequest, "AmazonConfig");
        String target = "StarlingDoveService.PutDeliveryChannel";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            DeliveryChannel deliveryChannel = putDeliveryChannelRequest.getDeliveryChannel();
            if (deliveryChannel != null) {
                jsonWriter.key("DeliveryChannel");
                jsonWriter.object();
                if (deliveryChannel.getName() != null) {
                    jsonWriter.key("name").value(deliveryChannel.getName());
                }
                if (deliveryChannel.getS3BucketName() != null) {
                    jsonWriter.key("s3BucketName").value(deliveryChannel.getS3BucketName());
                }
                if (deliveryChannel.getS3KeyPrefix() != null) {
                    jsonWriter.key("s3KeyPrefix").value(deliveryChannel.getS3KeyPrefix());
                }
                if (deliveryChannel.getSnsTopicARN() != null) {
                    jsonWriter.key("snsTopicARN").value(deliveryChannel.getSnsTopicARN());
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

