/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.elasticbeanstalk.model.CreateApplicationVersionRequest;
import com.amazonaws.services.elasticbeanstalk.model.S3Location;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateApplicationVersionRequestMarshaller
implements Marshaller<Request<CreateApplicationVersionRequest>, CreateApplicationVersionRequest> {
    @Override
    public Request<CreateApplicationVersionRequest> marshall(CreateApplicationVersionRequest createApplicationVersionRequest) {
        S3Location sourceBundle;
        if (createApplicationVersionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateApplicationVersionRequest> request = new DefaultRequest<CreateApplicationVersionRequest>(createApplicationVersionRequest, "AWSElasticBeanstalk");
        request.addParameter("Action", "CreateApplicationVersion");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createApplicationVersionRequest.getApplicationName() != null) {
            request.addParameter("ApplicationName", StringUtils.fromString(createApplicationVersionRequest.getApplicationName()));
        }
        if (createApplicationVersionRequest.getVersionLabel() != null) {
            request.addParameter("VersionLabel", StringUtils.fromString(createApplicationVersionRequest.getVersionLabel()));
        }
        if (createApplicationVersionRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString(createApplicationVersionRequest.getDescription()));
        }
        if ((sourceBundle = createApplicationVersionRequest.getSourceBundle()) != null) {
            if (sourceBundle.getS3Bucket() != null) {
                request.addParameter("SourceBundle.S3Bucket", StringUtils.fromString(sourceBundle.getS3Bucket()));
            }
            if (sourceBundle.getS3Key() != null) {
                request.addParameter("SourceBundle.S3Key", StringUtils.fromString(sourceBundle.getS3Key()));
            }
        }
        if (createApplicationVersionRequest.getAutoCreateApplication() != null) {
            request.addParameter("AutoCreateApplication", StringUtils.fromBoolean(createApplicationVersionRequest.getAutoCreateApplication()));
        }
        return request;
    }
}

