/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model.transform;

import com.amazonaws.services.elasticbeanstalk.model.Listener;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class ListenerStaxUnmarshaller
implements Unmarshaller<Listener, StaxUnmarshallerContext> {
    private static ListenerStaxUnmarshaller instance;

    @Override
    public Listener unmarshall(StaxUnmarshallerContext context) throws Exception {
        Listener listener = new Listener();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return listener;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Protocol", targetDepth)) {
                    listener.setProtocol(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Port", targetDepth)) continue;
                listener.setPort(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return listener;
    }

    public static ListenerStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ListenerStaxUnmarshaller();
        }
        return instance;
    }
}

