/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.identitymanagement.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.identitymanagement.model.AttachedPolicy;
import com.amazonaws.services.identitymanagement.model.InstanceProfile;
import com.amazonaws.services.identitymanagement.model.PolicyDetail;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class RoleDetail
implements Serializable,
Cloneable {
    private String path;
    private String roleName;
    private String roleId;
    private String arn;
    private Date createDate;
    private String assumeRolePolicyDocument;
    private ListWithAutoConstructFlag<InstanceProfile> instanceProfileList;
    private ListWithAutoConstructFlag<PolicyDetail> rolePolicyList;
    private ListWithAutoConstructFlag<AttachedPolicy> attachedManagedPolicies;

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public RoleDetail withPath(String path) {
        this.path = path;
        return this;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public RoleDetail withRoleName(String roleName) {
        this.roleName = roleName;
        return this;
    }

    public String getRoleId() {
        return this.roleId;
    }

    public void setRoleId(String roleId) {
        this.roleId = roleId;
    }

    public RoleDetail withRoleId(String roleId) {
        this.roleId = roleId;
        return this;
    }

    public String getArn() {
        return this.arn;
    }

    public void setArn(String arn) {
        this.arn = arn;
    }

    public RoleDetail withArn(String arn) {
        this.arn = arn;
        return this;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public RoleDetail withCreateDate(Date createDate) {
        this.createDate = createDate;
        return this;
    }

    public String getAssumeRolePolicyDocument() {
        return this.assumeRolePolicyDocument;
    }

    public void setAssumeRolePolicyDocument(String assumeRolePolicyDocument) {
        this.assumeRolePolicyDocument = assumeRolePolicyDocument;
    }

    public RoleDetail withAssumeRolePolicyDocument(String assumeRolePolicyDocument) {
        this.assumeRolePolicyDocument = assumeRolePolicyDocument;
        return this;
    }

    public List<InstanceProfile> getInstanceProfileList() {
        if (this.instanceProfileList == null) {
            this.instanceProfileList = new ListWithAutoConstructFlag();
            this.instanceProfileList.setAutoConstruct(true);
        }
        return this.instanceProfileList;
    }

    public void setInstanceProfileList(Collection<InstanceProfile> instanceProfileList) {
        if (instanceProfileList == null) {
            this.instanceProfileList = null;
            return;
        }
        ListWithAutoConstructFlag instanceProfileListCopy = new ListWithAutoConstructFlag(instanceProfileList.size());
        instanceProfileListCopy.addAll(instanceProfileList);
        this.instanceProfileList = instanceProfileListCopy;
    }

    public RoleDetail withInstanceProfileList(InstanceProfile ... instanceProfileList) {
        if (this.getInstanceProfileList() == null) {
            this.setInstanceProfileList(new ArrayList<InstanceProfile>(instanceProfileList.length));
        }
        for (InstanceProfile value : instanceProfileList) {
            this.getInstanceProfileList().add(value);
        }
        return this;
    }

    public RoleDetail withInstanceProfileList(Collection<InstanceProfile> instanceProfileList) {
        if (instanceProfileList == null) {
            this.instanceProfileList = null;
        } else {
            ListWithAutoConstructFlag instanceProfileListCopy = new ListWithAutoConstructFlag(instanceProfileList.size());
            instanceProfileListCopy.addAll(instanceProfileList);
            this.instanceProfileList = instanceProfileListCopy;
        }
        return this;
    }

    public List<PolicyDetail> getRolePolicyList() {
        if (this.rolePolicyList == null) {
            this.rolePolicyList = new ListWithAutoConstructFlag();
            this.rolePolicyList.setAutoConstruct(true);
        }
        return this.rolePolicyList;
    }

    public void setRolePolicyList(Collection<PolicyDetail> rolePolicyList) {
        if (rolePolicyList == null) {
            this.rolePolicyList = null;
            return;
        }
        ListWithAutoConstructFlag rolePolicyListCopy = new ListWithAutoConstructFlag(rolePolicyList.size());
        rolePolicyListCopy.addAll(rolePolicyList);
        this.rolePolicyList = rolePolicyListCopy;
    }

    public RoleDetail withRolePolicyList(PolicyDetail ... rolePolicyList) {
        if (this.getRolePolicyList() == null) {
            this.setRolePolicyList(new ArrayList<PolicyDetail>(rolePolicyList.length));
        }
        for (PolicyDetail value : rolePolicyList) {
            this.getRolePolicyList().add(value);
        }
        return this;
    }

    public RoleDetail withRolePolicyList(Collection<PolicyDetail> rolePolicyList) {
        if (rolePolicyList == null) {
            this.rolePolicyList = null;
        } else {
            ListWithAutoConstructFlag rolePolicyListCopy = new ListWithAutoConstructFlag(rolePolicyList.size());
            rolePolicyListCopy.addAll(rolePolicyList);
            this.rolePolicyList = rolePolicyListCopy;
        }
        return this;
    }

    public List<AttachedPolicy> getAttachedManagedPolicies() {
        if (this.attachedManagedPolicies == null) {
            this.attachedManagedPolicies = new ListWithAutoConstructFlag();
            this.attachedManagedPolicies.setAutoConstruct(true);
        }
        return this.attachedManagedPolicies;
    }

    public void setAttachedManagedPolicies(Collection<AttachedPolicy> attachedManagedPolicies) {
        if (attachedManagedPolicies == null) {
            this.attachedManagedPolicies = null;
            return;
        }
        ListWithAutoConstructFlag attachedManagedPoliciesCopy = new ListWithAutoConstructFlag(attachedManagedPolicies.size());
        attachedManagedPoliciesCopy.addAll(attachedManagedPolicies);
        this.attachedManagedPolicies = attachedManagedPoliciesCopy;
    }

    public RoleDetail withAttachedManagedPolicies(AttachedPolicy ... attachedManagedPolicies) {
        if (this.getAttachedManagedPolicies() == null) {
            this.setAttachedManagedPolicies(new ArrayList<AttachedPolicy>(attachedManagedPolicies.length));
        }
        for (AttachedPolicy value : attachedManagedPolicies) {
            this.getAttachedManagedPolicies().add(value);
        }
        return this;
    }

    public RoleDetail withAttachedManagedPolicies(Collection<AttachedPolicy> attachedManagedPolicies) {
        if (attachedManagedPolicies == null) {
            this.attachedManagedPolicies = null;
        } else {
            ListWithAutoConstructFlag attachedManagedPoliciesCopy = new ListWithAutoConstructFlag(attachedManagedPolicies.size());
            attachedManagedPoliciesCopy.addAll(attachedManagedPolicies);
            this.attachedManagedPolicies = attachedManagedPoliciesCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPath() != null) {
            sb.append("Path: " + this.getPath() + ",");
        }
        if (this.getRoleName() != null) {
            sb.append("RoleName: " + this.getRoleName() + ",");
        }
        if (this.getRoleId() != null) {
            sb.append("RoleId: " + this.getRoleId() + ",");
        }
        if (this.getArn() != null) {
            sb.append("Arn: " + this.getArn() + ",");
        }
        if (this.getCreateDate() != null) {
            sb.append("CreateDate: " + this.getCreateDate() + ",");
        }
        if (this.getAssumeRolePolicyDocument() != null) {
            sb.append("AssumeRolePolicyDocument: " + this.getAssumeRolePolicyDocument() + ",");
        }
        if (this.getInstanceProfileList() != null) {
            sb.append("InstanceProfileList: " + this.getInstanceProfileList() + ",");
        }
        if (this.getRolePolicyList() != null) {
            sb.append("RolePolicyList: " + this.getRolePolicyList() + ",");
        }
        if (this.getAttachedManagedPolicies() != null) {
            sb.append("AttachedManagedPolicies: " + this.getAttachedManagedPolicies());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPath() == null ? 0 : this.getPath().hashCode());
        hashCode = 31 * hashCode + (this.getRoleName() == null ? 0 : this.getRoleName().hashCode());
        hashCode = 31 * hashCode + (this.getRoleId() == null ? 0 : this.getRoleId().hashCode());
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getCreateDate() == null ? 0 : this.getCreateDate().hashCode());
        hashCode = 31 * hashCode + (this.getAssumeRolePolicyDocument() == null ? 0 : this.getAssumeRolePolicyDocument().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceProfileList() == null ? 0 : this.getInstanceProfileList().hashCode());
        hashCode = 31 * hashCode + (this.getRolePolicyList() == null ? 0 : this.getRolePolicyList().hashCode());
        hashCode = 31 * hashCode + (this.getAttachedManagedPolicies() == null ? 0 : this.getAttachedManagedPolicies().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RoleDetail)) {
            return false;
        }
        RoleDetail other = (RoleDetail)obj;
        if (other.getPath() == null ^ this.getPath() == null) {
            return false;
        }
        if (other.getPath() != null && !other.getPath().equals(this.getPath())) {
            return false;
        }
        if (other.getRoleName() == null ^ this.getRoleName() == null) {
            return false;
        }
        if (other.getRoleName() != null && !other.getRoleName().equals(this.getRoleName())) {
            return false;
        }
        if (other.getRoleId() == null ^ this.getRoleId() == null) {
            return false;
        }
        if (other.getRoleId() != null && !other.getRoleId().equals(this.getRoleId())) {
            return false;
        }
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getCreateDate() == null ^ this.getCreateDate() == null) {
            return false;
        }
        if (other.getCreateDate() != null && !other.getCreateDate().equals(this.getCreateDate())) {
            return false;
        }
        if (other.getAssumeRolePolicyDocument() == null ^ this.getAssumeRolePolicyDocument() == null) {
            return false;
        }
        if (other.getAssumeRolePolicyDocument() != null && !other.getAssumeRolePolicyDocument().equals(this.getAssumeRolePolicyDocument())) {
            return false;
        }
        if (other.getInstanceProfileList() == null ^ this.getInstanceProfileList() == null) {
            return false;
        }
        if (other.getInstanceProfileList() != null && !other.getInstanceProfileList().equals(this.getInstanceProfileList())) {
            return false;
        }
        if (other.getRolePolicyList() == null ^ this.getRolePolicyList() == null) {
            return false;
        }
        if (other.getRolePolicyList() != null && !other.getRolePolicyList().equals(this.getRolePolicyList())) {
            return false;
        }
        if (other.getAttachedManagedPolicies() == null ^ this.getAttachedManagedPolicies() == null) {
            return false;
        }
        return other.getAttachedManagedPolicies() == null || other.getAttachedManagedPolicies().equals(this.getAttachedManagedPolicies());
    }

    public RoleDetail clone() {
        try {
            return (RoleDetail)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

