/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.common.util;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.util.StringUtils;

public class TagUtil {
    public static final String TAGS = "tags";
    protected static final String DELIMITER = "|";

    public static boolean removeTag(String tag, Map<String, String> properties) {
        String tagsValue = properties.get(TAGS);
        Set<String> tags = TagUtil.parseTags(tagsValue);
        boolean result = tags.remove(tag);
        tagsValue = TagUtil.formatTags(tags);
        properties.put(TAGS, tagsValue);
        return result;
    }

    public static Set<String> parseTags(String tagsValue) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        if (StringUtils.hasText(tagsValue)) {
            set.addAll(Arrays.asList(tagsValue.split("[|]")));
        }
        return set;
    }

    private static String formatTags(Set<String> tags) {
        StringBuffer buf = new StringBuffer();
        String[] tagsArray = tags.toArray(new String[0]);
        for (int i = 0; i < tagsArray.length; ++i) {
            if (i > 0) {
                buf.append(DELIMITER);
            }
            buf.append(tagsArray[i]);
        }
        return buf.toString();
    }

    public static boolean addTag(String tag, Map<String, String> properties) {
        String tags = properties.get(TAGS);
        if (tags == null) {
            properties.put(TAGS, tag);
            return true;
        }
        Set<String> list = TagUtil.parseTags(tags);
        boolean result = list.add(tag);
        properties.put(TAGS, TagUtil.formatTags(list));
        return result;
    }

    public static void remove(String[] tags, Map<String, String> properties) {
        for (int i = 0; i < tags.length; ++i) {
            TagUtil.removeTag(tags[i], properties);
        }
    }

    public static void add(String[] tags, Map<String, String> properties) {
        for (int i = 0; i < tags.length; ++i) {
            TagUtil.addTag(tags[i], properties);
        }
    }
}

