/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.annotation;

import java.lang.reflect.Method;
import java.util.Map;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.AutowireCandidateQualifier;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.util.ObjectUtils;

public class BeanFactoryAnnotationUtils {
    public static <T> T qualifiedBeanOfType(BeanFactory beanFactory, Class<T> beanType, String qualifier) {
        if (beanFactory instanceof ConfigurableListableBeanFactory) {
            return BeanFactoryAnnotationUtils.qualifiedBeanOfType((ConfigurableListableBeanFactory)beanFactory, beanType, qualifier);
        }
        if (beanFactory.containsBean(qualifier)) {
            return beanFactory.getBean(qualifier, beanType);
        }
        throw new NoSuchBeanDefinitionException(qualifier, "No matching " + beanType.getSimpleName() + " bean found for bean name '" + qualifier + "'! (Note: Qualifier matching not supported because given " + "BeanFactory does not implement ConfigurableListableBeanFactory.)");
    }

    private static <T> T qualifiedBeanOfType(ConfigurableListableBeanFactory bf, Class<T> beanType, String qualifier) {
        Map<String, T> candidateBeans = BeanFactoryUtils.beansOfTypeIncludingAncestors(bf, beanType);
        T matchingBean = null;
        for (String beanName : candidateBeans.keySet()) {
            if (!BeanFactoryAnnotationUtils.isQualifierMatch(qualifier, beanName, bf)) continue;
            if (matchingBean != null) {
                throw new NoSuchBeanDefinitionException(qualifier, "No unique " + beanType.getSimpleName() + " bean found for qualifier '" + qualifier + "'");
            }
            matchingBean = candidateBeans.get(beanName);
        }
        if (matchingBean != null) {
            return matchingBean;
        }
        throw new NoSuchBeanDefinitionException(qualifier, "No matching " + beanType.getSimpleName() + " bean found for qualifier '" + qualifier + "' - neither qualifier " + "match nor bean name match!");
    }

    private static boolean isQualifierMatch(String qualifier, String beanName, ConfigurableListableBeanFactory bf) {
        if (bf.containsBean(beanName)) {
            try {
                Qualifier targetAnnotation;
                Method factoryMethod;
                AbstractBeanDefinition abd;
                AutowireCandidateQualifier candidate;
                BeanDefinition bd = bf.getMergedBeanDefinition(beanName);
                if (bd instanceof AbstractBeanDefinition && ((candidate = (abd = (AbstractBeanDefinition)bd).getQualifier(Qualifier.class.getName())) != null && qualifier.equals(candidate.getAttribute(AutowireCandidateQualifier.VALUE_KEY)) || qualifier.equals(beanName) || ObjectUtils.containsElement(bf.getAliases(beanName), qualifier))) {
                    return true;
                }
                if (bd instanceof RootBeanDefinition && (factoryMethod = ((RootBeanDefinition)bd).getResolvedFactoryMethod()) != null && (targetAnnotation = factoryMethod.getAnnotation(Qualifier.class)) != null && qualifier.equals(targetAnnotation.value())) {
                    return true;
                }
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                // empty catch block
            }
        }
        return false;
    }
}

