/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.appconfig;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.duracloud.appconfig.domain.AppConfig;
import org.duracloud.appconfig.domain.Application;
import org.duracloud.appconfig.domain.BaseConfig;
import org.duracloud.appconfig.domain.DurabossConfig;
import org.duracloud.appconfig.domain.DuradminConfig;
import org.duracloud.appconfig.domain.DurastoreConfig;
import org.duracloud.appconfig.domain.SecurityConfig;
import org.duracloud.appconfig.support.ApplicationWithConfig;
import org.duracloud.common.error.DuraCloudRuntimeException;
import org.duracloud.common.util.ChecksumUtil;
import org.duracloud.common.web.RestHttpHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationInitializer
extends BaseConfig {
    private final Logger log = LoggerFactory.getLogger(ApplicationInitializer.class);
    public static final String QUALIFIER = "app";
    private static final String duradminKey = "duradmin";
    private static final String durastoreKey = "durastore";
    private static final String durabossKey = "duraboss";
    protected static final String hostKey = "host";
    protected static final String portKey = "port";
    protected static final String contextKey = "context";
    protected static final String wildcardKey = "*";
    private String duradminHost;
    private String duradminPort;
    private String duradminContext;
    private String durastoreHost;
    private String durastorePort;
    private String durastoreContext;
    private String durabossHost;
    private String durabossPort;
    private String durabossContext;
    private SecurityConfig securityConfig = new SecurityConfig();
    private Map<String, ApplicationWithConfig> appsWithConfigs = new HashMap<String, ApplicationWithConfig>();

    public ApplicationInitializer(File propsFile) throws IOException {
        ChecksumUtil util = new ChecksumUtil(ChecksumUtil.Algorithm.SHA_256);
        Properties p = new Properties();
        p.load(new FileInputStream(propsFile));
        HashMap<String, String> props = new HashMap<String, String>();
        for (String key : p.stringPropertyNames()) {
            String value = p.get(key).toString();
            if (key.startsWith("security.user.") && key.endsWith(".password")) {
                value = util.generateChecksum(value);
            }
            props.put(key, value);
        }
        this.load(props);
    }

    @Override
    public void load(Map<String, String> props) {
        super.load(props);
        this.createApplications();
        this.securityConfig.load(props);
        for (ApplicationWithConfig appWithConfig : this.appsWithConfigs.values()) {
            appWithConfig.getConfig().load(props);
        }
    }

    private void createApplications() {
        ApplicationWithConfig appWithConfig;
        Application app;
        if (this.duradminEndpointLoad()) {
            app = new Application(this.duradminHost, this.duradminPort, this.duradminContext);
            appWithConfig = new ApplicationWithConfig(duradminKey);
            appWithConfig.setApplication(app);
            appWithConfig.setConfig(new DuradminConfig());
            this.appsWithConfigs.put(appWithConfig.getName(), appWithConfig);
        } else {
            this.log.warn("duradmin endpoint not !loaded");
        }
        if (this.durastoreEndpointLoad()) {
            app = new Application(this.durastoreHost, this.durastorePort, this.durastoreContext);
            appWithConfig = new ApplicationWithConfig(durastoreKey);
            appWithConfig.setApplication(app);
            appWithConfig.setConfig(new DurastoreConfig());
            this.appsWithConfigs.put(appWithConfig.getName(), appWithConfig);
        } else {
            this.log.warn("durastore endpoint !loaded");
        }
        if (this.durabossEndpointLoad()) {
            app = new Application(this.durabossHost, this.durabossPort, this.durabossContext);
            appWithConfig = new ApplicationWithConfig(durabossKey);
            appWithConfig.setApplication(app);
            appWithConfig.setConfig(new DurabossConfig());
            this.appsWithConfigs.put(appWithConfig.getName(), appWithConfig);
        } else {
            this.log.warn("duraboss endpoint not !loaded");
        }
    }

    private boolean duradminEndpointLoad() {
        return null != this.duradminHost && null != this.duradminPort && null != this.duradminContext;
    }

    private boolean durastoreEndpointLoad() {
        return null != this.durastoreHost && null != this.durastorePort && null != this.durastoreContext;
    }

    private boolean durabossEndpointLoad() {
        return null != this.durabossHost && null != this.durabossPort && null != this.durabossContext;
    }

    @Override
    protected String getQualifier() {
        return QUALIFIER;
    }

    @Override
    protected void loadProperty(String key, String value) {
        String prefix = this.getPrefix(key);
        String suffix = this.getSuffix(key);
        if (prefix.equalsIgnoreCase(duradminKey)) {
            this.loadDuradmin(suffix, value);
        } else if (prefix.equalsIgnoreCase(durastoreKey)) {
            this.loadDurastore(suffix, value);
        } else if (prefix.equalsIgnoreCase(durabossKey)) {
            this.loadDuraboss(suffix, value);
        } else if (prefix.equalsIgnoreCase(wildcardKey)) {
            this.loadDuradmin(suffix, value);
            this.loadDurastore(suffix, value);
            this.loadDuraboss(suffix, value);
        } else {
            String msg = "unknown key: " + key + " (" + value + ")";
            this.log.error(msg);
            throw new DuraCloudRuntimeException(msg);
        }
    }

    private void loadDuradmin(String key, String value) {
        String prefix = this.getPrefix(key);
        if (prefix.equalsIgnoreCase(hostKey)) {
            this.duradminHost = value;
        } else if (prefix.equalsIgnoreCase(portKey)) {
            this.duradminPort = value;
        } else if (prefix.equalsIgnoreCase(contextKey)) {
            this.duradminContext = value;
        } else {
            String msg = "unknown key: " + key + " (" + value + ")";
            this.log.error(msg);
            throw new DuraCloudRuntimeException(msg);
        }
    }

    private void loadDurastore(String key, String value) {
        String prefix = this.getPrefix(key);
        if (prefix.equalsIgnoreCase(hostKey)) {
            this.durastoreHost = value;
        } else if (prefix.equalsIgnoreCase(portKey)) {
            this.durastorePort = value;
        } else if (prefix.equalsIgnoreCase(contextKey)) {
            this.durastoreContext = value;
        } else {
            String msg = "unknown key: " + key + " (" + value + ")";
            this.log.error(msg);
            throw new DuraCloudRuntimeException(msg);
        }
    }

    private void loadDuraboss(String key, String value) {
        String prefix = this.getPrefix(key);
        if (prefix.equalsIgnoreCase(hostKey)) {
            this.durabossHost = value;
        } else if (prefix.equalsIgnoreCase(portKey)) {
            this.durabossPort = value;
        } else if (prefix.equalsIgnoreCase(contextKey)) {
            this.durabossContext = value;
        } else {
            String msg = "unknown key: " + key + " (" + value + ")";
            this.log.error(msg);
            throw new DuraCloudRuntimeException(msg);
        }
    }

    public RestHttpHelper.HttpResponse initialize() {
        RestHttpHelper.HttpResponse response = null;
        response = this.initApp(this.appsWithConfigs.get(durastoreKey));
        if (this.durabossEndpointLoad()) {
            response = this.initApp(this.appsWithConfigs.get(durabossKey));
        }
        response = this.initApp(this.appsWithConfigs.get(duradminKey));
        return response;
    }

    private RestHttpHelper.HttpResponse initApp(ApplicationWithConfig appWithConfig) {
        Application app = appWithConfig.getApplication();
        AppConfig config = appWithConfig.getConfig();
        RestHttpHelper.HttpResponse response = app.initialize(config);
        this.validate(response, appWithConfig.getName());
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validate(RestHttpHelper.HttpResponse response, String name) {
        if (null == response || response.getStatusCode() != 200) {
            String body = null;
            try {
                body = response.getResponseBody();
            }
            catch (IOException e) {}
            finally {
                StringBuilder msg = new StringBuilder("error initializing ");
                msg.append(name);
                msg.append(" (" + response.getStatusCode() + ")");
                if (null != body) {
                    msg.append("\n");
                    msg.append(body);
                }
                this.log.error(msg.toString());
                throw new DuraCloudRuntimeException(msg.toString());
            }
        }
    }

    public void setSecurityUsers() {
        RestHttpHelper.HttpResponse response = null;
        for (ApplicationWithConfig appWithConfig : this.appsWithConfigs.values()) {
            Application app = appWithConfig.getApplication();
            response = app.setSecurityUsers(this.securityConfig.getUsers());
            this.validate(response, appWithConfig.getName());
        }
    }

    public void outputXml(File dir) {
        for (ApplicationWithConfig appWithConfig : this.appsWithConfigs.values()) {
            String name = appWithConfig.getName();
            AppConfig config = appWithConfig.getConfig();
            this.write(new File(dir, name + "-init.xml"), config.asXml());
        }
        this.write(new File(dir, "security-init.xml"), this.securityConfig.asXml());
    }

    private void write(File file, String xml) {
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new FileWriter(file));
            bw.write(xml);
            bw.close();
        }
        catch (IOException e) {
            String msg = "error writing init xml: " + file.getPath();
            this.log.error(msg, (Throwable)e);
            throw new DuraCloudRuntimeException(msg, (Throwable)e);
        }
    }

    public Application getDuradmin() {
        return this.appsWithConfigs.get(duradminKey).getApplication();
    }

    public Application getDurastore() {
        return this.appsWithConfigs.get(durastoreKey).getApplication();
    }

    public Application getDuraboss() {
        return this.appsWithConfigs.get(durabossKey).getApplication();
    }
}

