/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.appconfig.domain;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.duracloud.appconfig.domain.AppConfig;
import org.duracloud.appconfig.domain.BaseConfig;
import org.duracloud.common.error.DuraCloudRuntimeException;
import org.duracloud.security.domain.SecurityUserBean;
import org.duracloud.security.xml.SecurityUsersDocumentBinding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityConfig
extends BaseConfig
implements AppConfig {
    private final Logger log = LoggerFactory.getLogger(SecurityConfig.class);
    private static final String INIT_RESOURCE = "/security";
    protected static final String QUALIFIER = "security";
    protected static final String userKey = "user";
    protected static final String usernameKey = "username";
    protected static final String passwordKey = "password";
    protected static final String enabledKey = "enabled";
    protected static final String emailKey = "email";
    protected static final String ipLimitsKey = "iplimits";
    protected static final String acctNonExpiredKey = "acct-non-expired";
    protected static final String credNonExpiredKey = "cred-non-expired";
    protected static final String acctNonLockedKey = "acct-non-locked";
    protected static final String grantsKey = "grants";
    protected static final String groupsKey = "groups";
    private Map<String, SecurityUserBean> users = new HashMap<String, SecurityUserBean>();

    @Override
    public String asXml() {
        return SecurityUsersDocumentBinding.createDocumentFrom(this.getUsers());
    }

    @Override
    public String getInitResource() {
        return INIT_RESOURCE;
    }

    @Override
    protected String getQualifier() {
        return QUALIFIER;
    }

    @Override
    protected void loadProperty(String key, String value) {
        String prefix = this.getPrefix(key = key.toLowerCase());
        if (!prefix.equalsIgnoreCase(userKey)) {
            String msg = "unknown key: " + key + " (" + value + ")";
            this.log.error(msg);
            throw new DuraCloudRuntimeException(msg);
        }
        String suffix = this.getSuffix(key);
        this.loadUser(suffix, value);
    }

    private void loadUser(String key, String value) {
        String suffix;
        String id = this.getPrefix(key);
        SecurityUserBean user = this.users.get(id);
        if (null == user) {
            user = new SecurityUserBean();
        }
        if (StringUtils.isBlank((String)(suffix = key.substring(id.length() + 1).toLowerCase()))) {
            String msg = "invalid key: " + key + " (" + value + ")";
            this.log.error(msg);
            throw new DuraCloudRuntimeException(msg);
        }
        if (suffix.equalsIgnoreCase(usernameKey)) {
            user.setUsername(value);
        } else if (suffix.equalsIgnoreCase(passwordKey)) {
            user.setPassword(value);
        } else if (suffix.equalsIgnoreCase(enabledKey)) {
            user.setEnabled(Boolean.valueOf(value).booleanValue());
        } else if (suffix.equalsIgnoreCase(emailKey)) {
            user.setEmail(value);
        } else if (suffix.equalsIgnoreCase(ipLimitsKey)) {
            user.setIpLimits(value);
        } else if (suffix.equalsIgnoreCase(acctNonExpiredKey)) {
            user.setAccountNonExpired(Boolean.valueOf(value).booleanValue());
        } else if (suffix.equalsIgnoreCase(credNonExpiredKey)) {
            user.setCredentialsNonExpired(Boolean.valueOf(value).booleanValue());
        } else if (suffix.equalsIgnoreCase(acctNonLockedKey)) {
            user.setAccountNonLocked(Boolean.valueOf(value).booleanValue());
        } else if (suffix.startsWith(grantsKey)) {
            user.addGrantedAuthority(value);
        } else if (suffix.startsWith(groupsKey)) {
            user.addGroup(value);
        } else {
            String msg = "unknown user key: " + key + " (" + value + ")";
            this.log.error(msg);
            throw new DuraCloudRuntimeException(msg);
        }
        this.users.put(id, user);
    }

    public Collection<SecurityUserBean> getUsers() {
        return this.users.values();
    }
}

