/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.appconfig.domain;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.duracloud.appconfig.domain.DuradminConfig;
import org.duracloud.appconfig.domain.NotificationConfig;
import org.duracloud.appconfig.xml.DurabossInitDocumentBinding;

public class DurabossConfig
extends DuradminConfig {
    public static final String QUALIFIER = "duraboss";
    public static final String notificationKey = "notification";
    public static final String notificationTypeKey = "type";
    public static final String notificationUsernameKey = "username";
    public static final String notificationPasswordKey = "password";
    public static final String notificationOriginatorKey = "originator";
    public static final String notificationAdminKey = "admin";
    public static final String reporterKey = "reporter";
    public static final String enabledKey = "enabled";
    private boolean reporterEnabled = true;
    private Map<String, NotificationConfig> notificationConfigs = new HashMap<String, NotificationConfig>();

    @Override
    protected boolean subclassLoadProperty(String key, String value) {
        String prefix = this.getPrefix(key);
        String suffix = this.getSuffix(key);
        if (prefix.equalsIgnoreCase(notificationKey)) {
            this.loadNotification(suffix, value);
            return true;
        }
        if (prefix.equalsIgnoreCase(reporterKey)) {
            this.loadReporter(suffix, value);
            return true;
        }
        return false;
    }

    private void loadNotification(String key, String value) {
        String id = this.getPrefix(key);
        String suffix = this.getSuffix(key);
        NotificationConfig config = this.notificationConfigs.get(id);
        if (null == config) {
            config = new NotificationConfig();
        }
        if (suffix.equalsIgnoreCase(notificationTypeKey)) {
            config.setType(value);
        } else if (suffix.equalsIgnoreCase(notificationUsernameKey)) {
            config.setUsername(value);
        } else if (suffix.equalsIgnoreCase(notificationPasswordKey)) {
            config.setPassword(value);
        } else if (suffix.equalsIgnoreCase(notificationOriginatorKey)) {
            config.setOriginator(value);
        } else if (suffix.startsWith(notificationAdminKey)) {
            List<String> admins = config.getAdmins();
            if (null == admins) {
                admins = new ArrayList<String>();
            }
            admins.add(value);
            config.setAdmins(admins);
        }
        this.notificationConfigs.put(id, config);
    }

    private void loadReporter(String key, String value) {
        String prefix = this.getPrefix(key);
        if (prefix.equalsIgnoreCase(enabledKey)) {
            this.reporterEnabled = Boolean.valueOf(value);
        }
    }

    @Override
    public String getInitResource() {
        return "/init";
    }

    @Override
    protected String getQualifier() {
        return QUALIFIER;
    }

    @Override
    protected boolean isSupported(String key) {
        return key != null && (key.startsWith(this.getQualifier()) || key.startsWith(super.getQualifier()));
    }

    @Override
    public String asXml() {
        return DurabossInitDocumentBinding.createDocumentFrom(this);
    }

    public void setNotificationConfigs(Map<String, NotificationConfig> notificationConfigs) {
        this.notificationConfigs = notificationConfigs;
    }

    public Collection<NotificationConfig> getNotificationConfigs() {
        return this.notificationConfigs.values();
    }

    public boolean isReporterEnabled() {
        return this.reporterEnabled;
    }

    public void setReporterEnabled(boolean reporterEnabled) {
        this.reporterEnabled = reporterEnabled;
    }
}

