/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.common.util;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;
import org.duracloud.common.error.DuraCloudRuntimeException;

public class EncryptionUtil {
    private static final String DEFAULT_KEY = "7437018461906678";
    private byte[] keyBytes;
    private Cipher cipher;
    private Key key;

    public EncryptionUtil() throws DuraCloudRuntimeException {
        this(DEFAULT_KEY);
    }

    public EncryptionUtil(String key) throws DuraCloudRuntimeException {
        if (key == null) {
            throw new IllegalArgumentException("'key' parameter must be non-null");
        }
        int keySize = DEFAULT_KEY.length();
        if (key.length() > keySize) {
            key = key.substring(0, keySize);
        }
        key = StringUtils.leftPad(key, keySize);
        this.keyBytes = key.getBytes();
        try {
            this.cipher = Cipher.getInstance("DES/ECB/PKCS5Padding");
            DESKeySpec deskey = new DESKeySpec(this.keyBytes);
            this.key = new SecretKeySpec(deskey.getKey(), "DES");
        }
        catch (Exception e) {
            throw new DuraCloudRuntimeException(e);
        }
    }

    public String encrypt(String toEncrypt) throws DuraCloudRuntimeException {
        try {
            byte[] input = toEncrypt.getBytes("UTF-8");
            this.cipher.init(1, this.key);
            byte[] cipherText = this.cipher.doFinal(input);
            return this.encodeBytes(cipherText);
        }
        catch (Exception e) {
            throw new DuraCloudRuntimeException(e);
        }
    }

    public String decrypt(String toDecrypt) throws DuraCloudRuntimeException {
        try {
            byte[] input = this.decodeBytes(toDecrypt);
            this.cipher.init(2, this.key);
            byte[] plainText = this.cipher.doFinal(input);
            return new String(plainText, "UTF-8");
        }
        catch (Exception e) {
            throw new DuraCloudRuntimeException(e);
        }
    }

    private String encodeBytes(byte[] cipherText) {
        StringBuffer cipherStringBuffer = new StringBuffer();
        for (int i = 0; i < cipherText.length; ++i) {
            byte b = cipherText[i];
            cipherStringBuffer.append(Byte.toString(b) + ":");
        }
        return cipherStringBuffer.toString();
    }

    private byte[] decodeBytes(String cipherString) {
        String[] cipherStringBytes = cipherString.split(":");
        byte[] cipherBytes = new byte[cipherStringBytes.length];
        for (int i = 0; i < cipherStringBytes.length; ++i) {
            cipherBytes[i] = Byte.parseByte(cipherStringBytes[i]);
        }
        return cipherBytes;
    }

    public static void main(String[] args) throws Exception {
        EncryptionUtil util = new EncryptionUtil();
        System.out.println("Enter text to encrypt: ");
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        String input = reader.readLine();
        if (null != input && !"".equals(input)) {
            System.out.println("'" + util.encrypt(input) + "'");
        }
    }
}

