/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.security.xml;

import java.util.Collection;
import org.duracloud.SecurityUserType;
import org.duracloud.SecurityUsersType;
import org.duracloud.security.domain.SecurityUserBean;

public class SecurityUserElementWriter {
    public static SecurityUsersType createSecurityUsersElementFrom(Collection<SecurityUserBean> users) {
        SecurityUsersType usersType = SecurityUsersType.Factory.newInstance();
        SecurityUserElementWriter.populateElementFromObject(usersType, users);
        return usersType;
    }

    private static void populateElementFromObject(SecurityUsersType usersType, Collection<SecurityUserBean> users) {
        usersType.setSchemaVersion("1.3");
        for (SecurityUserBean user : users) {
            SecurityUserType userType = usersType.addNewSecurityUser();
            SecurityUserElementWriter.populateUserType(userType, user);
        }
    }

    private static void populateUserType(SecurityUserType userType, SecurityUserBean user) {
        userType.setUsername(user.getUsername());
        userType.setPassword(user.getPassword());
        userType.setEmail(user.getEmail());
        userType.setIpLimits(user.getIpLimits());
        userType.setEnabled(user.isEnabled());
        userType.setCredentialsNonExpired(user.isCredentialsNonExpired());
        userType.setAccountNonExpired(user.isAccountNonExpired());
        userType.setAccountNonLocked(user.isAccountNonLocked());
        userType.setGrantedAuthorities(user.getGrantedAuthorities());
        userType.setGroups(user.getGroups());
    }
}

