/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.common.json;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.codehaus.jackson.map.AnnotationIntrospector;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.xc.JaxbAnnotationIntrospector;

public class JaxbJsonSerializer<T> {
    private Class type;
    private ObjectMapper mapper;

    public JaxbJsonSerializer(Class<T> type) {
        this.type = type;
        this.mapper = new ObjectMapper();
        this.mapper.configure(SerializationConfig.Feature.INDENT_OUTPUT, true);
        JaxbAnnotationIntrospector introspector = new JaxbAnnotationIntrospector();
        this.mapper.getDeserializationConfig().withAnnotationIntrospector((AnnotationIntrospector)introspector);
        this.mapper.getSerializationConfig().withAnnotationIntrospector((AnnotationIntrospector)introspector);
    }

    public String serialize(T object) throws IOException {
        StringWriter writer = new StringWriter();
        this.mapper.writeValue((Writer)writer, object);
        return writer.toString();
    }

    public T deserialize(String json) throws IOException {
        return (T)this.mapper.readValue(json, this.type);
    }
}

