/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.client;

import java.io.IOException;
import java.io.InputStream;
import org.duracloud.client.ContentStoreImpl;
import org.duracloud.common.retry.Retrier;
import org.duracloud.common.web.RestHttpHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PartialContentRetryInputStream
extends InputStream {
    private static final Logger log = LoggerFactory.getLogger(PartialContentRetryInputStream.class);
    private ContentStoreImpl contentStore;
    private String spaceId;
    private String contentId;
    private InputStream currentStream;
    private Long startByte;
    private Long endByte;
    private long nextBytePos;

    PartialContentRetryInputStream(ContentStoreImpl contentStore, String spaceId, String contentId, InputStream currentStream, Long startByte, Long endByte) {
        this.currentStream = currentStream;
        this.spaceId = spaceId;
        this.contentId = contentId;
        this.startByte = startByte;
        this.endByte = endByte;
        this.contentStore = contentStore;
        this.nextBytePos = startByte;
    }

    @Override
    public int read() throws IOException {
        try {
            int b = this.currentStream.read();
            ++this.nextBytePos;
            return b;
        }
        catch (IOException ex) {
            this.retryFromNextByte();
            return this.read();
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        try {
            int read = this.currentStream.read(b, off, len);
            if (read > -1) {
                this.nextBytePos += (long)read;
            }
            return read;
        }
        catch (IOException ex) {
            this.retryFromNextByte();
            return this.read(b, off, len);
        }
    }

    private void retryFromNextByte() throws IOException {
        log.info("Failed to read byte at position {} (space: {}, contentId: {}, startByte:{}, endByte: {}. Starting attempts to re-acquire stream from current position.", new Object[]{this.nextBytePos, this.spaceId, this.contentId, this.startByte, this.endByte});
        try {
            new Retrier(5, 4000, 3).execute(() -> {
                RestHttpHelper.HttpResponse response = this.contentStore.doGetContent(this.spaceId, this.contentId, this.nextBytePos, this.endByte);
                this.currentStream = response.getResponseStream();
                log.info("Successfully  re-acquired stream (space: {}, contentId: {}, nextBytePos:{}, endByte: {}. ", new Object[]{this.spaceId, this.contentId, this.nextBytePos, this.endByte});
                return null;
            });
        }
        catch (Exception e) {
            log.warn("Exhausted max retries to re-acquire stream (space: {}, contentId: {}, nextBytePos:{}, endByte: {}. ", new Object[]{this.spaceId, this.contentId, this.nextBytePos, this.endByte, e});
            throw new IOException(e.getMessage(), e);
        }
    }

    @Override
    public int available() {
        try {
            return this.currentStream.available();
        }
        catch (IOException ex) {
            return 0;
        }
    }

    @Override
    public void close() throws IOException {
        this.currentStream.close();
    }
}

