/*
 * Decompiled with CFR 0.152.
 */
package org.easetech.easytest.annotation;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.easetech.easytest.converter.Converter;
import org.easetech.easytest.converter.ConverterManager;
import org.easetech.easytest.internal.EasyParamSignature;
import org.easetech.easytest.util.DataContext;
import org.easetech.easytest.util.GeneralUtil;
import org.junit.Assert;
import org.junit.experimental.theories.PotentialAssignment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.PARAMETER})
public @interface Param {
    public String name();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DataSupplier {
        protected static final Logger LOG = LoggerFactory.getLogger(DataSupplier.class);
        private static final String COLON = ":";
        private static final String EMPTY_STRING = "";

        public List<PotentialAssignment> getValueSources(EasyParamSignature signature) {
            Class<?> parameterType;
            Param provider = signature.getAnnotation(Param.class);
            String value = DataContext.getMethodName();
            if (value == null) {
                Assert.fail((String)"The framework could not locate the test data for the test method. If you are using TestData annotation, make sure you specify the test method name in the data file. In case you are using ParametersSuppliedBy annotation, make sure you are using the right ParameterSupplier subclass.");
            }
            List<PotentialAssignment> listOfData = null;
            Map<String, List<Map<String, Object>>> data = DataContext.getConvertedData();
            List<Map<String, Object>> methodData = data.get(value);
            if (methodData == null) {
                Assert.fail((String)("Data does not exist for the specified method with name :" + value + " .Please check " + "that the Data file contains the data for the given method name. A possible cause could be spelling mismatch."));
            }
            listOfData = Map.class.isAssignableFrom(parameterType = signature.getParameterType()) ? this.convert(data.get(value), parameterType) : (Collection.class.isAssignableFrom(parameterType) ? this.convertCollection(signature, provider != null ? provider.name() : null, data.get(value), parameterType) : this.convert(signature.getParameterType(), provider != null ? provider.name() : null, data.get(value)));
            return listOfData;
        }

        private List<PotentialAssignment> convert(List<Map<String, Object>> convertFrom, Class mapType) {
            ArrayList<PotentialAssignment> finalData = new ArrayList<PotentialAssignment>();
            for (Map<String, Object> map : convertFrom) {
                Map dataValues;
                if (mapType.isInterface()) {
                    finalData.add(PotentialAssignment.forValue((String)EMPTY_STRING, map));
                    continue;
                }
                try {
                    dataValues = (Map)mapType.newInstance();
                }
                catch (InstantiationException e) {
                    LOG.error("InstantiationException occured while trying to convert the data to Map(using newInstance() method). The type of Map passed as input parameter is :" + mapType, (Throwable)e);
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    LOG.error("IllegalAccessException occured while trying to convert the data to Map(using newInstance() method). The type of Map passed as input parameter is :" + mapType, (Throwable)e);
                    throw new RuntimeException(e);
                }
                dataValues.putAll(map);
                finalData.add(PotentialAssignment.forValue((String)EMPTY_STRING, (Object)dataValues));
            }
            return finalData;
        }

        private List<PotentialAssignment> convert(Class<?> idClass, String paramName, List<Map<String, Object>> convertFrom) {
            ArrayList<PotentialAssignment> potentialAssignments = new ArrayList<PotentialAssignment>();
            if (GeneralUtil.isStandardObjectInstance(idClass)) {
                for (Map<String, Object> object : convertFrom) {
                    potentialAssignments.add(PotentialAssignment.forValue((String)EMPTY_STRING, (Object)GeneralUtil.convertToTargetType(idClass, object.get(paramName))));
                }
            } else {
                PropertyEditor editor = PropertyEditorManager.findEditor(idClass);
                if (editor != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Editor for class " + idClass + " found.");
                    }
                    for (Map<String, Object> object : convertFrom) {
                        if (paramName != null && !EMPTY_STRING.equals(paramName)) {
                            if (DataSupplier.getStringValue(paramName, object) != null) {
                                editor.setAsText(DataSupplier.getStringValue(paramName, object));
                            }
                        } else if (DataSupplier.getStringValue(idClass.getSimpleName(), object) != null) {
                            editor.setAsText(DataSupplier.getStringValue(idClass.getSimpleName(), object));
                        }
                        potentialAssignments.add(PotentialAssignment.forValue((String)EMPTY_STRING, (Object)editor.getValue()));
                    }
                } else {
                    Converter<?> converter;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Editor for class " + idClass + " not found. Trying to find converter.");
                    }
                    if ((converter = ConverterManager.findConverter(idClass)) != null) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Converter for class " + idClass + "  found. ");
                        }
                        for (Map<String, Object> object : convertFrom) {
                            potentialAssignments.add(PotentialAssignment.forValue((String)EMPTY_STRING, converter.convert(object)));
                        }
                    } else if (!GeneralUtil.populateJSONData(idClass, convertFrom, potentialAssignments, paramName).booleanValue()) {
                        try {
                            GeneralUtil.populateParamData(idClass, convertFrom, potentialAssignments, paramName);
                        }
                        catch (IllegalArgumentException e) {
                            LOG.error("Exception occured while trying to populate the data by instantiating the parameter object", (Throwable)e);
                            throw e;
                        }
                        catch (InstantiationException e) {
                            LOG.error("Exception occured while trying to populate the data by instantiating the parameter object", (Throwable)e);
                            throw new RuntimeException(e);
                        }
                        catch (IllegalAccessException e) {
                            LOG.error("Exception occured while trying to populate the data by instantiating the parameter object", (Throwable)e);
                            throw new RuntimeException(e);
                        }
                        catch (InvocationTargetException e) {
                            LOG.error("Exception occured while trying to populate the data by instantiating the parameter object", (Throwable)e);
                            throw new RuntimeException(e);
                        }
                    }
                }
            }
            return potentialAssignments;
        }

        private List<PotentialAssignment> convertCollection(EasyParamSignature signature, String paramName, List<Map<String, Object>> convertFrom, Class parameterType) {
            Class genericType = signature.getIsGenericParameter() != false ? signature.getGenericParameterArgType() : Object.class;
            Collection objectValues = DataSupplier.getCollectionInstance(parameterType, genericType);
            ArrayList<PotentialAssignment> finalData = new ArrayList<PotentialAssignment>();
            if (!signature.getIsGenericParameter().booleanValue()) {
                LOG.debug("Collection is of Non generic type.Setting the same values as fetched from the test file.");
                for (Map<String, Object> object : convertFrom) {
                    String[] strValues = ((String)object.get(paramName)).split(COLON);
                    for (int i = 0; i < strValues.length; ++i) {
                        objectValues.add(strValues[i]);
                    }
                    finalData.add(PotentialAssignment.forValue((String)EMPTY_STRING, (Object)objectValues));
                }
            } else if (GeneralUtil.isStandardObjectInstance(genericType)) {
                LOG.debug("parameter to the collection is a Standard Java Class {} . Using Internal Editors to resolve values", genericType);
                if (objectValues == null) {
                    Assert.fail((String)("Unable to identify the Collection with Class :" + parameterType));
                }
                for (Map<String, Object> object : convertFrom) {
                    String[] strValues = ((String)object.get(paramName)).split(COLON);
                    for (int i = 0; i < strValues.length; ++i) {
                        objectValues.add(GeneralUtil.convertToTargetType(genericType, strValues[i]));
                    }
                    finalData.add(PotentialAssignment.forValue((String)EMPTY_STRING, (Object)objectValues));
                }
            } else {
                PropertyEditor editor = PropertyEditorManager.findEditor(genericType);
                if (editor != null) {
                    LOG.debug("Editor for class {} found", genericType);
                    for (Map<String, Object> object : convertFrom) {
                        String strValue = null;
                        strValue = paramName != null && !EMPTY_STRING.equals(paramName) ? DataSupplier.getStringValue(paramName, object) : DataSupplier.getStringValue(genericType.getSimpleName(), object);
                        if (strValue != null) {
                            String[] values = strValue.split(COLON);
                            for (int i = 0; i < values.length; ++i) {
                                editor.setAsText(values[i]);
                                if (editor.getValue() == null) continue;
                                objectValues.add(editor.getValue());
                            }
                        }
                        finalData.add(PotentialAssignment.forValue((String)EMPTY_STRING, (Object)objectValues));
                    }
                } else {
                    LOG.debug("Editor for class {}  not found. Trying to find converter.", genericType);
                    Converter<?> converter = ConverterManager.findConverter(genericType);
                    if (converter != null) {
                        LOG.debug("Converter for class {} found ", genericType);
                        for (Map<String, Object> object : convertFrom) {
                            HashMap<String, Object> tempMap = new HashMap<String, Object>();
                            String values = (String)object.get(paramName);
                            String[] splitValues = values.split(COLON);
                            for (int i = 0; i < splitValues.length; ++i) {
                                tempMap.put(paramName, splitValues[i]);
                                objectValues.add(converter.convert(tempMap));
                            }
                            finalData.add(PotentialAssignment.forValue((String)EMPTY_STRING, (Object)objectValues));
                        }
                    } else {
                        try {
                            GeneralUtil.fillDataUsingConstructor(genericType, convertFrom, finalData, paramName, objectValues);
                        }
                        catch (IllegalArgumentException e) {
                            LOG.error("Exception occured while trying to populate the data by instantiating the parameter object", (Throwable)e);
                            throw e;
                        }
                        catch (InstantiationException e) {
                            LOG.error("Exception occured while trying to populate the data by instantiating the parameter object", (Throwable)e);
                            throw new RuntimeException(e);
                        }
                        catch (IllegalAccessException e) {
                            LOG.error("Exception occured while trying to populate the data by instantiating the parameter object", (Throwable)e);
                            throw new RuntimeException(e);
                        }
                        catch (InvocationTargetException e) {
                            LOG.error("Exception occured while trying to populate the data by instantiating the parameter object", (Throwable)e);
                            throw new RuntimeException(e);
                        }
                    }
                }
            }
            return finalData;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static Collection getCollectionInstance(Class parameterType, Class genericType) {
            try {
                if (Set.class.isAssignableFrom(parameterType)) {
                    if (!EnumSet.class.isAssignableFrom(parameterType)) return parameterType.isInterface() || Modifier.isAbstract(parameterType.getModifiers()) ? new TreeSet() : parameterType.newInstance();
                    LOG.debug("Returning an instance of {}  for the input parameter of Type :{}", (Object)EnumSet.class.getSimpleName(), (Object)parameterType);
                    return EnumSet.noneOf(genericType == null ? Object.class : genericType);
                }
                if (List.class.isAssignableFrom(parameterType)) {
                    return parameterType.isInterface() || Modifier.isAbstract(parameterType.getModifiers()) ? new LinkedList() : parameterType.newInstance();
                }
                if ("Deque".equals(parameterType.getSimpleName()) || "LinkedBlockingDeque".equals(parameterType.getSimpleName()) || "BlockingDeque".equals(parameterType.getSimpleName())) {
                    Converter<?> converter = ConverterManager.findConverter(parameterType);
                    if (converter != null) return (Collection)converter.instanceOfType();
                    Assert.fail((String)("EasyTest does not natively support the Collection of type " + parameterType + " . In order to use this Collection type as parameter, provide an empty implementation of AbstractConveter " + "class with the generic type as " + parameterType + "or provide an implementation of instance() method of the Converter interface "));
                    return null;
                } else {
                    if (Queue.class.isAssignableFrom(parameterType)) {
                        if (!ArrayBlockingQueue.class.isAssignableFrom(parameterType)) return parameterType.isInterface() || Modifier.isAbstract(parameterType.getModifiers()) ? new LinkedBlockingQueue() : parameterType.newInstance();
                        return new ArrayBlockingQueue(100);
                    }
                    if (!Collection.class.isAssignableFrom(parameterType)) return null;
                    return new ArrayList();
                }
            }
            catch (InstantiationException e) {
                LOG.error("InstantiationException occured while trying to instantiate a Collection of Type : {} . Error is {}", (Object)parameterType, (Object)e);
                Assert.fail((String)("InstantiationException occured while trying to instantiate a Collection of Type : " + parameterType + " . The exception is :" + e.getMessage()));
                return null;
            }
            catch (IllegalAccessException e) {
                LOG.error("IllegalAccessException occured while trying to instantiate a Collection of Type : {} . Error is {}", (Object)parameterType, (Object)e);
                Assert.fail((String)("IllegalAccessException occured while trying to instantiate a Collection of Type : " + parameterType + " . The exception is :" + e.getMessage()));
                return null;
            }
            catch (IllegalArgumentException e) {
                LOG.error("IllegalArgumentException occured while trying to instantiate a Collection of Type : {} . Error is {}", (Object)parameterType, (Object)e);
                Assert.fail((String)("IllegalArgumentException occured while trying to instantiate a Collection of Type : " + parameterType + " . The exception is :" + e.getMessage()));
                return null;
            }
            catch (SecurityException e) {
                LOG.error("SecurityException occured while trying to instantiate a Collection of Type : {} . Error is {}", (Object)parameterType, (Object)e);
                Assert.fail((String)("SecurityException occured while trying to instantiate a Collection of Type : " + parameterType + " . The exception is :" + e.getMessage()));
            }
            return null;
        }

        private static String getStringValue(String paramName, Map<String, Object> data) {
            return data.get(paramName) != null && !data.get(paramName).equals("null") ? data.get(paramName).toString() : null;
        }
    }
}

