/*
 * Decompiled with CFR 0.152.
 */
package org.easetech.easytest.internal;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.easetech.easytest.annotation.Param;
import org.easetech.easytest.internal.EasyParamSignature;
import org.junit.experimental.theories.PotentialAssignment;
import org.junit.runners.model.TestClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EasyAssignments {
    private List<PotentialAssignment> fAssigned;
    private final List<EasyParamSignature> fUnassigned;
    private final TestClass fClass;

    public EasyAssignments(List<PotentialAssignment> assigned, List<EasyParamSignature> unassigned, TestClass testClass) {
        this.fUnassigned = unassigned;
        this.fAssigned = assigned;
        this.fClass = testClass;
    }

    public static EasyAssignments allUnassigned(Method testMethod, TestClass testClass) throws Exception {
        List<EasyParamSignature> signatures = EasyParamSignature.signatures(testClass.getOnlyConstructor());
        signatures.addAll(EasyParamSignature.signatures(testMethod));
        return new EasyAssignments(new ArrayList<PotentialAssignment>(), signatures, testClass);
    }

    public boolean isComplete() {
        return this.fUnassigned.size() == 0;
    }

    public EasyParamSignature nextUnassigned() {
        return this.fUnassigned.get(0);
    }

    public EasyAssignments assignNext(PotentialAssignment source) {
        ArrayList<PotentialAssignment> assigned = new ArrayList<PotentialAssignment>(this.fAssigned);
        assigned.add(source);
        return new EasyAssignments(assigned, this.fUnassigned.subList(1, this.fUnassigned.size()), this.fClass);
    }

    public Object[] getActualValues(int start, int stop, boolean nullsOk) throws PotentialAssignment.CouldNotGenerateValueException {
        Object[] values = new Object[stop - start];
        for (int i = start; i < stop; ++i) {
            Object value = this.fAssigned.get(i).getValue();
            if (value == null && !nullsOk) {
                throw new PotentialAssignment.CouldNotGenerateValueException();
            }
            values[i - start] = value;
        }
        return values;
    }

    public List<PotentialAssignment> potentialsForNextUnassigned() throws InstantiationException, IllegalAccessException {
        EasyParamSignature unassigned = this.nextUnassigned();
        return this.getSupplier(unassigned).getValueSources(unassigned);
    }

    public Param.DataSupplier getSupplier(EasyParamSignature unassigned) throws InstantiationException, IllegalAccessException {
        return new Param.DataSupplier();
    }

    public Object[] getConstructorArguments(boolean nullsOk) throws PotentialAssignment.CouldNotGenerateValueException {
        return this.getActualValues(0, this.getConstructorParameterCount(), nullsOk);
    }

    public Object[] getMethodArguments(boolean nullsOk) throws PotentialAssignment.CouldNotGenerateValueException {
        return this.getActualValues(this.getConstructorParameterCount(), this.fAssigned.size(), nullsOk);
    }

    public Object[] getAllArguments(boolean nullsOk) throws PotentialAssignment.CouldNotGenerateValueException {
        return this.getActualValues(0, this.fAssigned.size(), nullsOk);
    }

    private int getConstructorParameterCount() {
        List<EasyParamSignature> signatures = EasyParamSignature.signatures(this.fClass.getOnlyConstructor());
        int constructorParameterCount = signatures.size();
        return constructorParameterCount;
    }

    public Object[] getArgumentStrings(boolean nullsOk) throws PotentialAssignment.CouldNotGenerateValueException {
        Object[] values = new Object[this.fAssigned.size()];
        for (int i = 0; i < values.length; ++i) {
            values[i] = this.fAssigned.get(i).getDescription();
        }
        return values;
    }
}

