/*
 * Decompiled with CFR 0.152.
 */
package org.easetech.easytest.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.easetech.easytest.io.Resource;
import org.easetech.easytest.util.CommonUtils;
import org.junit.Assert;

public class FileSystemResource
implements Resource {
    private String path;
    private File file;

    public FileSystemResource(String path) {
        if (path == null || path.length() <= 0) {
            Assert.fail((String)"The supplied path must be a non empty and Not Null value");
        }
        this.path = CommonUtils.cleanPath(path);
        this.file = new File(path);
    }

    public FileSystemResource(File file) {
        if (this.path == null || this.path.length() <= 0) {
            Assert.fail((String)"The supplied path must be a non empty and Not Null value");
        }
        this.path = CommonUtils.cleanPath(file.getPath());
        this.file = file;
    }

    public String getPath() {
        return this.path;
    }

    public boolean exists() {
        return this.file.exists();
    }

    public InputStream getInputStream() {
        try {
            return new FileInputStream(this.file);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public URL getURL() {
        try {
            return this.file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public File getFile() {
        return this.file;
    }

    public String getResourceName() {
        return this.file.getPath();
    }

    public OutputStream getOutputStream() {
        try {
            return new FileOutputStream(this.file);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return "FileSystemResource [path=" + this.path + ", file=" + this.file + "]";
    }
}

