/*
 * Decompiled with CFR 0.152.
 */
package org.easetech.easytest.io;

import java.net.MalformedURLException;
import java.net.URL;
import org.easetech.easytest.io.ClasspathResource;
import org.easetech.easytest.io.FileSystemResource;
import org.easetech.easytest.io.Resource;
import org.easetech.easytest.io.ResourceLoader;
import org.easetech.easytest.io.UrlResource;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceLoaderStrategy
implements ResourceLoader {
    protected static final Logger LOG = LoggerFactory.getLogger(ResourceLoaderStrategy.class);
    private ClassLoader classLoader;
    private Class<?> classObj;

    public ResourceLoaderStrategy() {
        this.classLoader = Thread.currentThread().getContextClassLoader();
    }

    public ResourceLoaderStrategy(Class classObj) {
        this.classObj = classObj;
    }

    public ResourceLoaderStrategy(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ResourceLoaderStrategy(ClassLoader classLoader, Class classObj) {
        this.classLoader = classLoader;
        this.classObj = classObj;
    }

    @Override
    public Resource getResource(String location) {
        String locationWithoutClasspathPrefix;
        Resource resource = null;
        String string = locationWithoutClasspathPrefix = location.startsWith("classpath:") ? location.substring("classpath:".length()) : location;
        if (location == null || location.length() <= 0) {
            Assert.fail((String)"The location specified can not be Null or empty");
        }
        if (!(resource = new ClasspathResource(locationWithoutClasspathPrefix, this.getClassLoader(), this.classObj)).exists()) {
            LOG.debug("Could not find the resource with path {} in the classpath. Trying to load the resource as a URL", (Object)location);
            try {
                URL url = new URL(location);
                resource = new UrlResource(url);
                if (!resource.exists()) {
                    LOG.debug("Could not load the resource with path {} as a URL. Trying to load the resource as a FileSystemResource", (Object)location);
                    resource = new FileSystemResource(location);
                }
            }
            catch (MalformedURLException ex) {
                resource = new FileSystemResource(location);
            }
        }
        if (resource == null || !resource.exists()) {
            LOG.error("Could not load the resource with path {} as either a Classpath, FileSystem or a URL resource", (Object)location);
            Assert.fail((String)("Could not load the resource with path " + location + " as either a Classpath, " + "FileSystem or a URL resource. Please check the path and try again"));
        }
        return resource;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Class<?> getClassObj() {
        return this.classObj;
    }
}

