/*
 * Decompiled with CFR 0.152.
 */
package org.easetech.easytest.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import org.easetech.easytest.io.Resource;
import org.easetech.easytest.util.CommonUtils;
import org.jfree.util.Log;
import org.junit.Assert;

public class UrlResource
implements Resource {
    private String path;
    private URL URL;

    public UrlResource(String path) throws MalformedURLException {
        if (path == null || path.length() <= 0) {
            Assert.fail((String)"The supplied path must be a non empty and Not Null value");
        }
        this.path = path;
        this.URL = new URL(path);
    }

    public UrlResource(URL url) {
        if (this.path == null || this.path.length() <= 0) {
            Assert.fail((String)"The supplied path must be a non empty and Not Null value");
        }
        this.path = url.getPath();
        this.URL = url;
    }

    public String getPath() {
        return this.path;
    }

    public boolean exists() {
        try {
            return this.getFile().exists();
        }
        catch (Exception e) {
            Log.debug((Object)"Exception occured while trying to find whether the resource exists or not ", (Exception)e);
            return false;
        }
    }

    public InputStream getInputStream() throws IOException {
        URLConnection con = this.URL.openConnection();
        con.setUseCaches(false);
        return con.getInputStream();
    }

    public URL getURL() {
        return this.URL;
    }

    public File getFile() throws Exception {
        URI uri = CommonUtils.toURI(this.getURL());
        File file = uri != null ? CommonUtils.getFile(uri, this.getResourceName()) : CommonUtils.getFile(this.getURL(), this.getResourceName());
        return file;
    }

    private URL getCleanedUrl(URL originalUrl, String originalPath) {
        try {
            return new URL(CommonUtils.cleanPath(originalPath));
        }
        catch (MalformedURLException ex) {
            return originalUrl;
        }
    }

    public String getResourceName() {
        try {
            return this.getFile().getName();
        }
        catch (Exception e) {
            Log.debug((Object)"Exception occured while trying to get the name of the resource", (Exception)e);
            return this.path;
        }
    }

    public OutputStream getOutputStream() throws IOException {
        URLConnection con = this.URL.openConnection();
        con.setUseCaches(false);
        return con.getOutputStream();
    }

    public String toString() {
        return "UrlResource [path=" + this.path + ", URL=" + this.URL + "]";
    }
}

