/*
 * Decompiled with CFR 0.152.
 */
package org.easetech.easytest.reports.data;

import java.util.ArrayList;
import java.util.List;
import org.easetech.easytest.annotation.Report;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportParametersBean {
    protected static final Logger LOG = LoggerFactory.getLogger(ReportParametersBean.class);
    private Report.EXPORT_FORMAT[] outputFormats;
    private String outputLocation;
    private List<String> packageNames = null;

    public ReportParametersBean(Report.EXPORT_FORMAT[] outputFormats, String outputLocation) {
        LOG.info("Processing reports with annotations outputFormats=" + outputFormats + " outputLocation=" + outputLocation);
        this.outputFormats = outputFormats;
        this.outputLocation = outputLocation;
    }

    public ReportParametersBean(String reportsFormat, String outputLocation, String packages) {
        LOG.info("Processing reports with command line parameters reports.generate=true reports.format=" + reportsFormat + " reports.location=" + outputLocation + " packages=" + packages);
        ArrayList<Report.EXPORT_FORMAT> formatResults = new ArrayList<Report.EXPORT_FORMAT>();
        if (reportsFormat != null) {
            String[] formats;
            for (String format : formats = reportsFormat.split(",")) {
                try {
                    formatResults.add(Report.EXPORT_FORMAT.valueOf(format.toUpperCase().trim()));
                }
                catch (Exception e) {
                    LOG.error("Report format " + format + " not supported", (Throwable)e);
                }
            }
        }
        if (formatResults.isEmpty()) {
            formatResults.add(Report.EXPORT_FORMAT.PDF);
            LOG.info("Outputting to PDF as default format");
        }
        this.outputFormats = formatResults.toArray(new Report.EXPORT_FORMAT[formatResults.size()]);
        String string = this.outputLocation = outputLocation != null ? outputLocation : "";
        if (packages != null) {
            String[] packagesArray;
            this.packageNames = new ArrayList<String>();
            for (String packageName : packagesArray = packages.split(",")) {
                this.packageNames.add(packageName.trim());
            }
        }
    }

    public Report.EXPORT_FORMAT[] getOutputFormats() {
        return this.outputFormats;
    }

    public String getOutputLocation() {
        return this.outputLocation;
    }

    public List<String> getPackageNames() {
        return this.packageNames;
    }
}

