/*
 * Decompiled with CFR 0.152.
 */
package org.easetech.easytest.runner;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.easetech.easytest.annotation.Converters;
import org.easetech.easytest.annotation.DataLoader;
import org.easetech.easytest.converter.Converter;
import org.easetech.easytest.converter.ConverterManager;
import org.easetech.easytest.loader.DataConverter;
import org.easetech.easytest.loader.DataLoaderUtil;
import org.easetech.easytest.runner.TestConfigUtil;
import org.junit.Test;
import org.junit.runner.Runner;
import org.junit.runners.Suite;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseSuite
extends Suite {
    protected static Map<String, List<Map<String, Object>>> writableData = new HashMap<String, List<Map<String, Object>>>();
    protected final List<Runner> runners = new ArrayList<Runner>();
    protected List<FrameworkMethod> methodsWithNoData = new ArrayList<FrameworkMethod>();
    protected List<FrameworkMethod> methodsWithData = new ArrayList<FrameworkMethod>();

    protected List<Runner> getChildren() {
        return this.runners;
    }

    protected BaseSuite(Class<?> klass) throws InitializationError {
        super(klass, Collections.emptyList());
        Class testClass = this.getTestClass().getJavaClass();
        TestConfigUtil.loadTestBeanConfig(testClass);
        DataLoaderUtil.loadData(klass, null, this.getTestClass(), writableData);
        this.registerConverter(testClass.getAnnotation(Converters.class));
        List availableMethods = this.getTestClass().getAnnotatedMethods(Test.class);
        ArrayList<FrameworkMethod> methodsWithNoData = new ArrayList<FrameworkMethod>();
        ArrayList<FrameworkMethod> methodsWithData = new ArrayList<FrameworkMethod>();
        for (FrameworkMethod method : availableMethods) {
            if (method.getAnnotation(DataLoader.class) != null) {
                DataLoaderUtil.loadData(null, method, this.getTestClass(), writableData);
                methodsWithData.add(method);
            } else if (method.getMethod().getParameterTypes().length == 0) {
                methodsWithNoData.add(method);
            } else {
                boolean methodDataLoaded = DataLoaderUtil.isMethodDataLoaded(DataConverter.getFullyQualifiedTestName(method.getName(), testClass));
                if (methodDataLoaded) {
                    methodsWithData.add(method);
                } else {
                    methodsWithNoData.add(method);
                }
            }
            this.registerConverter((Converters)method.getAnnotation(Converters.class));
        }
        if (!methodsWithNoData.isEmpty()) {
            this.methodsWithNoData = methodsWithNoData;
        }
        if (!methodsWithData.isEmpty()) {
            this.methodsWithData = methodsWithData;
        }
    }

    public void registerConverter(Converters converter) {
        Class<? extends Converter>[] convertersToRegister;
        if (converter != null && (convertersToRegister = converter.value()) != null && convertersToRegister.length != 0) {
            for (Class<? extends Converter> value : convertersToRegister) {
                ConverterManager.registerConverter(value);
            }
        }
    }

    protected Statement withBeforeClasses(Statement statement) {
        return statement;
    }

    protected Statement withAfterClasses(Statement statement) {
        return statement;
    }
}

