/*
 * Decompiled with CFR 0.152.
 */
package org.easetech.easytest.runner;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import org.easetech.easytest.annotation.DataLoader;
import org.easetech.easytest.annotation.Intercept;
import org.easetech.easytest.interceptor.InternalInterceptor;
import org.easetech.easytest.interceptor.InternalInvocationhandler;
import org.easetech.easytest.interceptor.MethodIntercepter;
import org.easetech.easytest.loader.DataConverter;
import org.easetech.easytest.loader.DataLoaderUtil;
import org.easetech.easytest.reports.data.ReportDataContainer;
import org.easetech.easytest.reports.data.TestResultBean;
import org.easetech.easytest.runner.BaseSuite;
import org.easetech.easytest.runner.EasyFrameworkMethod;
import org.easetech.easytest.runner.InternalParameterizedStatement;
import org.easetech.easytest.runner.TestConfigUtil;
import org.easetech.easytest.util.DataContext;
import org.easetech.easytest.util.RunAftersWithOutputData;
import org.easetech.easytest.util.TestInfo;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataDrivenTestRunner
extends BaseSuite {
    protected static final Logger PARAM_LOG = LoggerFactory.getLogger(DataDrivenTestRunner.class);

    public DataDrivenTestRunner(Class<?> klass) throws InitializationError {
        super(klass);
        this.runners.add(new EasyTestRunner(klass));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class EasyTestRunner
    extends BlockJUnit4ClassRunner {
        List<FrameworkMethod> frameworkMethods;
        Object testInstance;
        private ReportDataContainer testReportContainer;
        TestResultBean testResult;

        public EasyTestRunner(Class<?> klass) throws InitializationError {
            super(klass);
            this.testReportContainer = null;
            try {
                this.testInstance = this.getTestClass().getOnlyConstructor().newInstance(new Object[0]);
                TestConfigUtil.loadTestConfigurations(this.getTestClass().getJavaClass(), this.testInstance);
                TestConfigUtil.loadResourceProperties(this.getTestClass().getJavaClass(), this.testInstance);
                this.instrumentClass(this.getTestClass().getJavaClass());
                this.testReportContainer = new ReportDataContainer(this.getTestClass().getJavaClass());
            }
            catch (Exception e) {
                PARAM_LOG.error("Exception occured while instantiating the EasyTestRunner. Exception is : ", (Throwable)e);
                throw new RuntimeException(e);
            }
        }

        protected void instrumentClass(Class<?> testClass) throws IllegalArgumentException, IllegalAccessException, InstantiationException {
            Field[] fields;
            for (Field field : fields = testClass.getDeclaredFields()) {
                field.setAccessible(true);
                Intercept interceptor = field.getAnnotation(Intercept.class);
                if (interceptor == null) continue;
                Class<? extends MethodIntercepter> interceptorClass = interceptor.interceptor();
                Class<?> fieldType = field.getType();
                Object fieldInstance = field.get(this.testInstance);
                Object proxiedObject = null;
                if (fieldType.isInterface()) {
                    PARAM_LOG.debug("The field of type :" + fieldType + " will be proxied using JDK dynamic proxies.");
                    ClassLoader classLoader = this.determineClassLoader(fieldType, testClass);
                    Class[] interfaces = new Class[]{fieldType};
                    InternalInvocationhandler handler = new InternalInvocationhandler();
                    handler.setUserIntercepter(interceptorClass.newInstance());
                    handler.setTargetInstance(fieldInstance);
                    proxiedObject = Proxy.newProxyInstance(classLoader, interfaces, (InvocationHandler)handler);
                } else {
                    PARAM_LOG.debug("The field of type :" + fieldType + " will be proxied using CGLIB proxies.");
                    Enhancer enhancer = new Enhancer();
                    enhancer.setSuperclass(fieldType);
                    InternalInterceptor cglibInterceptor = new InternalInterceptor();
                    cglibInterceptor.setTargetInstance(fieldInstance);
                    cglibInterceptor.setUserIntercepter(interceptorClass.newInstance());
                    enhancer.setCallback((Callback)cglibInterceptor);
                    proxiedObject = enhancer.create();
                }
                try {
                    if (proxiedObject == null) continue;
                    field.set(this.testInstance, proxiedObject);
                }
                catch (Exception e) {
                    PARAM_LOG.error("Failed while trying to instrument the class for Intercept annotation with exception : ", (Throwable)e);
                    Assert.fail((String)("Failed while trying to instrument the class for Intercept annotation with exception : " + e));
                }
            }
        }

        protected ClassLoader determineClassLoader(Class<?> fieldType, Class<?> testClass) {
            ClassLoader cl = testClass.getClassLoader();
            try {
                if (Class.forName(fieldType.getName(), false, cl) == fieldType) {
                    return cl;
                }
                cl = Thread.currentThread().getContextClassLoader();
                if (Class.forName(fieldType.getName(), false, cl) == fieldType) {
                    return cl;
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            return null;
        }

        protected void collectInitializationErrors(List<Throwable> errors) {
            super.collectInitializationErrors(errors);
        }

        protected String testName(FrameworkMethod method) {
            return String.format("%s", method.getName());
        }

        protected List<FrameworkMethod> computeTestMethods() {
            if (this.frameworkMethods != null && !this.frameworkMethods.isEmpty()) {
                return this.frameworkMethods;
            }
            ArrayList<FrameworkMethod> finalList = new ArrayList<FrameworkMethod>();
            Class testClass = this.getTestClass().getJavaClass();
            block0: for (FrameworkMethod methodWithData : DataDrivenTestRunner.this.methodsWithData) {
                String superMethodName = DataConverter.getFullyQualifiedTestName(methodWithData.getName(), testClass);
                for (FrameworkMethod method : super.computeTestMethods()) {
                    if (!superMethodName.equals(DataConverter.getFullyQualifiedTestName(method.getName(), testClass))) continue;
                    List<Map<String, Object>> methodData = null;
                    if (DataContext.getData() != null) {
                        methodData = DataContext.getData().get(superMethodName);
                    }
                    if (methodData == null) {
                        Assert.fail((String)("Method with name : " + superMethodName + " expects some input test data. But there doesnt seem to be any test " + "data for the given method. Please check the Test Data file for the method data. " + "Possible cause could be that the data did not get loaded at all from the file " + "or a spelling mismatch in the method name. Check logs for more details."));
                    }
                    for (Map map : methodData) {
                        EasyFrameworkMethod easyMethod = new EasyFrameworkMethod(method.getMethod());
                        easyMethod.setName(method.getName().concat(map.toString()));
                        finalList.add(easyMethod);
                    }
                    continue block0;
                }
            }
            finalList.addAll(DataDrivenTestRunner.this.methodsWithNoData);
            if (finalList.isEmpty()) {
                Assert.fail((String)"No method exists for the Test Runner");
            }
            this.frameworkMethods = finalList;
            return finalList;
        }

        protected void validateConstructor(List<Throwable> errors) {
            this.validateOnlyOneConstructor(errors);
        }

        protected void validateTestMethods(List<Throwable> errors) {
        }

        public Statement methodBlock(FrameworkMethod method) {
            return new InternalParameterizedStatement(method, this.testResult, this.testReportContainer, BaseSuite.writableData, this.getTestClass(), this.testInstance);
        }

        protected Statement withAfterClasses(Statement statement) {
            List afters = this.getTestClass().getAnnotatedMethods(AfterClass.class);
            List testMethods = this.getTestClass().getAnnotatedMethods(Test.class);
            ArrayList<TestInfo> testInfoList = new ArrayList<TestInfo>();
            for (FrameworkMethod method : testMethods) {
                TestInfo testInfo = null;
                DataLoader loaderAnnotation = (DataLoader)method.getAnnotation(DataLoader.class);
                if (loaderAnnotation != null) {
                    testInfo = DataLoaderUtil.determineLoader(loaderAnnotation, this.getTestClass());
                } else {
                    loaderAnnotation = this.getTestClass().getJavaClass().getAnnotation(DataLoader.class);
                    if (loaderAnnotation != null) {
                        testInfo = DataLoaderUtil.determineLoader(loaderAnnotation, this.getTestClass());
                    }
                }
                if (testInfo == null) continue;
                testInfo.setMethodName(method.getName());
                testInfoList.add(testInfo);
            }
            RunAftersWithOutputData runAftersWithOutputData = new RunAftersWithOutputData(statement, afters, null, testInfoList, BaseSuite.writableData, this.testReportContainer);
            return runAftersWithOutputData;
        }
    }
}

