/*
 * Decompiled with CFR 0.152.
 */
package org.easetech.easytest.runner;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.easetech.easytest.exceptions.ParamAssertionError;
import org.easetech.easytest.internal.EasyAssignments;
import org.easetech.easytest.loader.DataConverter;
import org.easetech.easytest.reports.data.DurationBean;
import org.easetech.easytest.reports.data.ReportDataContainer;
import org.easetech.easytest.reports.data.TestResultBean;
import org.easetech.easytest.runner.EasyTestRunListener;
import org.easetech.easytest.runner.TestRunDurationListener;
import org.easetech.easytest.util.CommonUtils;
import org.easetech.easytest.util.DataContext;
import org.junit.Assert;
import org.junit.experimental.theories.PotentialAssignment;
import org.junit.internal.AssumptionViolatedException;
import org.junit.internal.runners.model.EachTestNotifier;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternalParameterizedStatement
extends Statement {
    protected final Logger LOG = LoggerFactory.getLogger(InternalParameterizedStatement.class);
    private int successes = 0;
    private FrameworkMethod fTestMethod;
    TestResultBean testResult;
    private ReportDataContainer testReportContainer = null;
    private static String mapMethodName = "";
    private static int rowNum = 0;
    private Map<String, List<Map<String, Object>>> writableData = new HashMap<String, List<Map<String, Object>>>();
    private List<EasyAssignments> listOfAssignments;
    private List<AssumptionViolatedException> fInvalidParameters = new ArrayList<AssumptionViolatedException>();
    private TestClass fTestClass;
    Object testInstance;

    public InternalParameterizedStatement(FrameworkMethod fTestMethod, TestResultBean testResult, ReportDataContainer testReportContainer, Map<String, List<Map<String, Object>>> writableData, TestClass testClass, Object testInstance) {
        this.fTestMethod = fTestMethod;
        this.testResult = testResult == null ? new TestResultBean() : testResult;
        this.testReportContainer = testReportContainer;
        this.writableData = writableData;
        this.listOfAssignments = new ArrayList<EasyAssignments>();
        this.fTestClass = testClass;
        this.testInstance = testInstance;
        DataContext.setMethodName(DataConverter.getFullyQualifiedTestName(fTestMethod.getName(), testClass.getJavaClass()));
    }

    private TestClass getTestClass() {
        return this.fTestClass;
    }

    public void evaluate() throws Throwable {
        this.runWithAssignment(EasyAssignments.allUnassigned(this.fTestMethod.getMethod(), this.getTestClass()));
        this.LOG.debug("ParamAnchor evaluate");
        if (this.successes == 0) {
            Assert.fail((String)("Never found parameters that satisfied method assumptions.  Violated assumptions: " + this.fInvalidParameters));
        }
    }

    protected void runWithAssignment(EasyAssignments parameterAssignment) throws Throwable {
        while (!parameterAssignment.isComplete()) {
            List<PotentialAssignment> potentialAssignments = parameterAssignment.potentialsForNextUnassigned();
            boolean isFirstSetOfArguments = this.listOfAssignments.isEmpty();
            for (int i = 0; i < potentialAssignments.size(); ++i) {
                EasyAssignments assignments;
                if (isFirstSetOfArguments) {
                    assignments = EasyAssignments.allUnassigned(this.fTestMethod.getMethod(), this.getTestClass());
                    this.listOfAssignments.add(assignments.assignNext(potentialAssignments.get(i)));
                    continue;
                }
                assignments = this.listOfAssignments.get(i);
                try {
                    this.listOfAssignments.set(i, assignments.assignNext(potentialAssignments.get(i)));
                    continue;
                }
                catch (IndexOutOfBoundsException e) {
                    this.listOfAssignments.add(assignments.assignNext(potentialAssignments.get(i)));
                }
            }
            parameterAssignment = parameterAssignment.assignNext(null);
        }
        if (this.listOfAssignments.isEmpty()) {
            this.LOG.debug("The list of Assignments is null. It normally happens when the user has not supplied any parameters to the test.");
            this.LOG.debug(" Creating an instance of Assignments object with all its value unassigned.");
            this.listOfAssignments.add(EasyAssignments.allUnassigned(this.fTestMethod.getMethod(), this.getTestClass()));
        }
        for (EasyAssignments assignments : this.listOfAssignments) {
            this.runWithCompleteAssignment(assignments);
        }
    }

    protected void runWithCompleteAssignment(final EasyAssignments complete) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, Throwable {
        new BlockJUnit4ClassRunner(this.getTestClass().getJavaClass()){

            protected void collectInitializationErrors(List<Throwable> errors) {
            }

            public Statement methodBlock(FrameworkMethod method) {
                final Statement statement = super.methodBlock(method);
                RunNotifier notifier = new RunNotifier();
                notifier.addListener((RunListener)new EasyTestRunListener());
                final EachTestNotifier eachNotifier = new EachTestNotifier(notifier, null);
                eachNotifier.fireTestStarted();
                return new Statement(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void evaluate() throws Throwable {
                        try {
                            statement.evaluate();
                            InternalParameterizedStatement.this.handleDataPointSuccess();
                        }
                        catch (AssumptionViolatedException e) {
                            eachNotifier.addFailedAssumption(e);
                            InternalParameterizedStatement.this.handleAssumptionViolation(e);
                        }
                        catch (Throwable e) {
                            if (e instanceof AssertionError) {
                                InternalParameterizedStatement.this.testResult.setPassed(Boolean.FALSE);
                                InternalParameterizedStatement.this.testResult.setResult(e.getMessage());
                                InternalParameterizedStatement.this.testReportContainer.addTestResult(InternalParameterizedStatement.this.testResult);
                            } else {
                                InternalParameterizedStatement.this.testResult.setException(Boolean.TRUE);
                                InternalParameterizedStatement.this.testResult.setExceptionResult(e.toString());
                                InternalParameterizedStatement.this.testReportContainer.addTestResult(InternalParameterizedStatement.this.testResult);
                            }
                            eachNotifier.addFailure(e);
                            InternalParameterizedStatement.this.reportParameterizedError(e, complete.getArgumentStrings(true));
                        }
                        finally {
                            eachNotifier.fireTestFinished();
                        }
                    }
                };
            }

            protected Statement methodInvoker(FrameworkMethod method, Object test) {
                return InternalParameterizedStatement.this.methodCompletesWithParameters(method, complete, test);
            }

            public Object createTest() throws Exception {
                return InternalParameterizedStatement.this.testInstance;
            }
        }.methodBlock(this.fTestMethod).evaluate();
    }

    private Statement methodCompletesWithParameters(final FrameworkMethod method, final EasyAssignments complete, final Object freshInstance) {
        RunNotifier testRunNotifier = new RunNotifier();
        final TestRunDurationListener testRunDurationListener = new TestRunDurationListener();
        testRunNotifier.addListener((RunListener)testRunDurationListener);
        final EachTestNotifier eachRunNotifier = new EachTestNotifier(testRunNotifier, null);
        return new Statement(){

            public void evaluate() throws Throwable {
                String currentMethodName = method.getMethod().getName();
                InternalParameterizedStatement.this.testResult = new TestResultBean();
                InternalParameterizedStatement.this.testResult.setMethod(currentMethodName);
                InternalParameterizedStatement.this.testResult.setDate(new Date());
                Object returnObj = null;
                Map writableRow = null;
                try {
                    Object[] values = complete.getMethodArguments(true);
                    boolean testContainsInputParams = values.length != 0;
                    Map inputData = null;
                    eachRunNotifier.fireTestStarted();
                    InternalParameterizedStatement.this.LOG.debug("Calling method {} with values {}", (Object)method.getName(), (Object)values);
                    returnObj = method.invokeExplosively(freshInstance, values);
                    eachRunNotifier.fireTestFinished();
                    DurationBean testItemDurationBean = new DurationBean(currentMethodName, testRunDurationListener.getStartInNano(), testRunDurationListener.getEndInNano());
                    InternalParameterizedStatement.this.testResult.addTestItemDurationBean(testItemDurationBean);
                    InternalParameterizedStatement.this.testResult.setOutput(returnObj == null ? "void" : returnObj);
                    InternalParameterizedStatement.this.testResult.setPassed(Boolean.TRUE);
                    if (!mapMethodName.equals(method.getMethod().getName())) {
                        mapMethodName = method.getMethod().getName();
                        rowNum = 0;
                    }
                    if (InternalParameterizedStatement.this.writableData.get(mapMethodName) != null) {
                        if (((List)InternalParameterizedStatement.this.writableData.get(mapMethodName)).size() > 0) {
                            inputData = (Map)((List)InternalParameterizedStatement.this.writableData.get(mapMethodName)).get(rowNum);
                            writableRow = (Map)((List)InternalParameterizedStatement.this.writableData.get(mapMethodName)).get(rowNum);
                        } else {
                            inputData = null;
                            ((List)InternalParameterizedStatement.this.writableData.get(mapMethodName)).add(new HashMap());
                            writableRow = (Map)((List)InternalParameterizedStatement.this.writableData.get(mapMethodName)).get(rowNum);
                        }
                        InternalParameterizedStatement.this.LOG.debug("writableData.get({}) is {} ", (Object)mapMethodName, InternalParameterizedStatement.this.writableData.get(mapMethodName));
                        InternalParameterizedStatement.this.testResult.setInput(inputData);
                    } else {
                        InternalParameterizedStatement.this.testResult.setInput(null);
                    }
                    if (writableRow != null) {
                        if (returnObj != null) {
                            Object expectedResult;
                            InternalParameterizedStatement.this.LOG.debug("Data returned by method {} is {} :", (Object)method.getName(), returnObj);
                            InternalParameterizedStatement.this.LOG.debug("mapMethodName:" + mapMethodName + " ,rowNum:" + rowNum);
                            writableRow.put("ActualResult", returnObj);
                            if (testContainsInputParams) {
                                InternalParameterizedStatement.this.LOG.debug("writableData.get({}) is {} ", (Object)mapMethodName, InternalParameterizedStatement.this.writableData.get(mapMethodName));
                                inputData.put("ActualResult", returnObj);
                            }
                            if ((expectedResult = writableRow.get("ExpectedResult")) != null) {
                                InternalParameterizedStatement.this.LOG.debug("Expected result exists");
                                if (expectedResult.toString().equals(returnObj.toString())) {
                                    writableRow.put("TestStatus", "PASSED");
                                } else {
                                    writableRow.put("TestStatus", "FAILED");
                                }
                            }
                        }
                        InternalParameterizedStatement.this.LOG.debug("testItemDurationBean:" + testItemDurationBean);
                        if (testItemDurationBean != null) {
                            Double testDuration = CommonUtils.getRounded(testItemDurationBean.getRoundedMsDifference().doubleValue(), 3);
                            InternalParameterizedStatement.this.LOG.debug("testItemDurationBean.getRoundedMsDifference():" + testDuration);
                            writableRow.put("Duration(ms)", testDuration);
                        }
                        InternalParameterizedStatement.this.LOG.debug("rowNum:" + rowNum);
                        rowNum++;
                    }
                }
                catch (PotentialAssignment.CouldNotGenerateValueException e) {
                    throw new RuntimeException(e);
                }
                InternalParameterizedStatement.this.testReportContainer.addTestResult(InternalParameterizedStatement.this.testResult);
                if (writableRow != null && writableRow.get("TestStatus") != null && writableRow.get("TestStatus").equals("FAILED")) {
                    Assert.fail((String)("Actual Result returned by the method : [" + returnObj + "] did not match the expected result : [" + writableRow.get("ExpectedResult") + "]"));
                }
            }
        };
    }

    protected void handleAssumptionViolation(AssumptionViolatedException e) {
        this.fInvalidParameters.add(e);
    }

    protected void reportParameterizedError(Throwable e, Object ... params) throws Throwable {
        if (params.length == 0) {
            throw e;
        }
        throw new ParamAssertionError(e, this.fTestMethod.getName(), params);
    }

    protected void handleDataPointSuccess() {
        ++this.successes;
    }
}

