/*
 * Decompiled with CFR 0.152.
 */
package org.easetech.easytest.util;

import java.util.HashMap;
import java.util.Map;

public final class ConfigContext {
    public static final ThreadLocal<Map<String, Object>> beansByName = new ThreadLocal();
    public static final ThreadLocal<Map<Class, Object>> beansByType = new ThreadLocal();

    private ConfigContext() {
    }

    public static void setTestBeanByName(String beanName, Object beanInstance) {
        Map<String, Object> beanNamesMap = beansByName.get();
        if (beanNamesMap == null) {
            beanNamesMap = new HashMap<String, Object>();
        }
        beanNamesMap.put(beanName, beanInstance);
        beansByName.set(beanNamesMap);
    }

    public static void setTestBeanByType(Class beanType, Object beanInstance) {
        Map<Class, Object> beanTypesMap = beansByType.get();
        if (beanTypesMap == null) {
            beanTypesMap = new HashMap<Class, Object>();
        }
        beanTypesMap.put(beanType, beanInstance);
        beansByType.set(beanTypesMap);
    }

    public static Object getBeanByName(String beanName) {
        Map<String, Object> beanNamesMap = beansByName.get();
        if (beanNamesMap == null) {
            return null;
        }
        return beanNamesMap.get(beanName);
    }

    public static Object getBeanByType(Class beanType) {
        Map<Class, Object> beanTypesMap = beansByType.get();
        if (beanTypesMap == null) {
            return null;
        }
        return beanTypesMap.get(beanType);
    }
}

