/*
 * Decompiled with CFR 0.152.
 */
package org.easetech.easytest.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.easetech.easytest.annotation.Report;
import org.easetech.easytest.io.ResourceLoaderStrategy;
import org.easetech.easytest.reports.data.ReportDataContainer;
import org.easetech.easytest.reports.data.ReportParametersBean;
import org.easetech.easytest.reports.impl.ReportRunner;
import org.easetech.easytest.util.CommonUtils;
import org.easetech.easytest.util.TestInfo;
import org.junit.experimental.theories.internal.ParameterizedAssertionError;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.MultipleFailureException;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunAftersWithOutputData
extends Statement {
    protected static final Logger LOG = LoggerFactory.getLogger(RunAftersWithOutputData.class);
    private Map<String, List<Map<String, Object>>> writableData;
    private final Statement fNext;
    private final Object fTarget;
    private final List<TestInfo> testInfoList;
    private final List<FrameworkMethod> fAfters;
    private ReportDataContainer testReportContainer;

    public RunAftersWithOutputData(Statement next, List<FrameworkMethod> afters, Object target, List<TestInfo> testInfoList, Map<String, List<Map<String, Object>>> writableData, ReportDataContainer testReportContainer) {
        this.fNext = next;
        this.fAfters = afters;
        this.fTarget = target;
        this.testInfoList = testInfoList;
        this.writableData = writableData;
        this.testReportContainer = testReportContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evaluate() throws Throwable {
        LOG.info("evaluate started");
        Future<Boolean> submit = null;
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        try {
            this.fNext.evaluate();
        }
        catch (Throwable e) {
            errors.add(e);
        }
        finally {
            submit = this.processReports(this.testReportContainer);
            for (FrameworkMethod each : this.fAfters) {
                try {
                    each.invokeExplosively(this.fTarget, new Object[0]);
                }
                catch (Throwable e) {
                    errors.add(e);
                }
            }
        }
        MultipleFailureException.assertEmpty(errors);
        for (TestInfo testInfo : this.testInfoList) {
            if (testInfo.getFilePaths() == null || testInfo.getDataLoader() == null) continue;
            try {
                ResourceLoaderStrategy resourceLoader = new ResourceLoaderStrategy(testInfo.getTestClass().getJavaClass());
                for (String filePath : testInfo.getFilePaths()) {
                    testInfo.getDataLoader().writeData(resourceLoader.getResource(filePath), this.writableData, testInfo.getMethodName());
                }
            }
            catch (Exception e) {
                throw new ParameterizedAssertionError((Throwable)e, testInfo.getMethodName(), new Object[]{testInfo});
            }
        }
        if (submit != null) {
            long start = System.nanoTime();
            while (!submit.isDone()) {
            }
            long end = (System.nanoTime() - start) / 1000000L;
            LOG.debug("Writing reports took: {} ms.", (Object)end);
        }
    }

    private Future<Boolean> processReports(ReportDataContainer testReportContainer) {
        Future<Boolean> submit = null;
        if (testReportContainer != null) {
            Report annotation = testReportContainer.getTestClass().getAnnotation(Report.class);
            ReportParametersBean reportParameters = null;
            if (System.getProperty("reports.generate") != null) {
                reportParameters = new ReportParametersBean(System.getProperty("reports.format"), System.getProperty("reports.location"), System.getProperty("reports.package"));
            } else if (annotation != null) {
                reportParameters = new ReportParametersBean(annotation.outputFormats(), annotation.outputLocation());
            } else {
                return null;
            }
            String rawOutputLocation = reportParameters.getOutputLocation();
            Report.EXPORT_FORMAT[] outputFormats = reportParameters.getOutputFormats();
            String absoluteLocation = CommonUtils.getAbsoluteLocation(rawOutputLocation);
            String outputLocation = CommonUtils.createFolder(absoluteLocation);
            if (outputLocation != null) {
                ExecutorService executor = Executors.newCachedThreadPool();
                LOG.info("Writing reports to folder: {} ", (Object)outputLocation);
                ReportRunner reportExecuter = new ReportRunner(testReportContainer, outputFormats, outputLocation);
                submit = executor.submit(reportExecuter);
            } else {
                LOG.error("Can't write reports. Report output location {}  can't be created.", (Object)rawOutputLocation);
            }
        }
        return submit;
    }
}

