/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.condition;

import org.fest.assertions.condition.Join;
import org.fest.assertions.core.Condition;

public class AllOf<T>
extends Join<T> {
    public static <T> Condition<T> allOf(Condition<? super T> ... conditions) {
        return new AllOf<T>(conditions);
    }

    public static <T> Condition<T> allOf(Iterable<? extends Condition<? super T>> conditions) {
        return new AllOf<T>(conditions);
    }

    private AllOf(Condition<? super T> ... conditions) {
        super(conditions);
    }

    private AllOf(Iterable<? extends Condition<? super T>> conditions) {
        super(conditions);
    }

    @Override
    public boolean matches(T value) {
        for (Condition condition : this.conditions) {
            if (condition.matches(value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return String.format("all of:<%s>", this.conditions);
    }
}

