/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api;

import java.util.Comparator;
import org.fest.assertions.api.AbstractAssert;
import org.fest.assertions.core.AssertionInfo;
import org.fest.assertions.core.Condition;
import org.fest.assertions.core.ObjectEnumerableAssert;
import org.fest.assertions.internal.ComparatorBasedComparisonStrategy;
import org.fest.assertions.internal.Iterables;
import org.fest.util.VisibleForTesting;

public abstract class AbstractIterableAssert<S extends AbstractIterableAssert<S, A, T>, A extends Iterable<T>, T>
extends AbstractAssert<S, A>
implements ObjectEnumerableAssert<S, T> {
    @VisibleForTesting
    Iterables iterables = Iterables.instance();

    protected AbstractIterableAssert(A actual, Class<?> selfType) {
        super(actual, selfType);
    }

    @Override
    public void isNullOrEmpty() {
        this.iterables.assertNullOrEmpty(this.info, (Iterable)this.actual);
    }

    @Override
    public void isEmpty() {
        this.iterables.assertEmpty(this.info, (Iterable)this.actual);
    }

    @Override
    public S isNotEmpty() {
        this.iterables.assertNotEmpty(this.info, (Iterable)this.actual);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S hasSize(int expected) {
        this.iterables.assertHasSize(this.info, (Iterable)this.actual, expected);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S hasSameSizeAs(Object[] other) {
        this.iterables.assertHasSameSizeAs((AssertionInfo)this.info, (Iterable)this.actual, other);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S hasSameSizeAs(Iterable<?> other) {
        this.iterables.assertHasSameSizeAs((AssertionInfo)this.info, (Iterable)this.actual, other);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S contains(T ... values) {
        this.iterables.assertContains(this.info, (Iterable)this.actual, values);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S containsOnly(T ... values) {
        this.iterables.assertContainsOnly(this.info, (Iterable)this.actual, values);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S containsExactly(T ... values) {
        this.iterables.assertContainsExactly(this.info, (Iterable)this.actual, values);
        return (S)((AbstractIterableAssert)this.myself);
    }

    public S isSubsetOf(Iterable<? extends T> values) {
        this.iterables.assertIsSubsetOf(this.info, (Iterable)this.actual, values);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S containsSequence(T ... sequence) {
        this.iterables.assertContainsSequence(this.info, (Iterable)this.actual, sequence);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S doesNotContain(T ... values) {
        this.iterables.assertDoesNotContain(this.info, (Iterable)this.actual, values);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S doesNotHaveDuplicates() {
        this.iterables.assertDoesNotHaveDuplicates(this.info, (Iterable)this.actual);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S startsWith(T ... sequence) {
        this.iterables.assertStartsWith(this.info, (Iterable)this.actual, sequence);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S endsWith(T ... sequence) {
        this.iterables.assertEndsWith(this.info, (Iterable)this.actual, sequence);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S containsNull() {
        this.iterables.assertContainsNull(this.info, (Iterable)this.actual);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S doesNotContainNull() {
        this.iterables.assertDoesNotContainNull(this.info, (Iterable)this.actual);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S are(Condition<? super T> condition) {
        this.iterables.assertAre(this.info, (Iterable)this.actual, condition);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S areNot(Condition<? super T> condition) {
        this.iterables.assertAreNot(this.info, (Iterable)this.actual, condition);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S have(Condition<? super T> condition) {
        this.iterables.assertHave(this.info, (Iterable)this.actual, condition);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S doNotHave(Condition<? super T> condition) {
        this.iterables.assertDoNotHave(this.info, (Iterable)this.actual, condition);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S areAtLeast(int times, Condition<? super T> condition) {
        this.iterables.assertAreAtLeast(this.info, (Iterable)this.actual, times, condition);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S areNotAtLeast(int times, Condition<? super T> condition) {
        this.iterables.assertAreNotAtLeast(this.info, (Iterable)this.actual, times, condition);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S areAtMost(int times, Condition<? super T> condition) {
        this.iterables.assertAreAtMost(this.info, (Iterable)this.actual, times, condition);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S areNotAtMost(int times, Condition<? super T> condition) {
        this.iterables.assertAreNotAtMost(this.info, (Iterable)this.actual, times, condition);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S areExactly(int times, Condition<? super T> condition) {
        this.iterables.assertAreExactly(this.info, (Iterable)this.actual, times, condition);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S areNotExactly(int times, Condition<? super T> condition) {
        this.iterables.assertAreNotExactly(this.info, (Iterable)this.actual, times, condition);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S haveAtLeast(int times, Condition<? super T> condition) {
        this.iterables.assertHaveAtLeast(this.info, (Iterable)this.actual, times, condition);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S doNotHaveAtLeast(int times, Condition<? super T> condition) {
        this.iterables.assertDoNotHaveAtLeast(this.info, (Iterable)this.actual, times, condition);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S haveAtMost(int times, Condition<? super T> condition) {
        this.iterables.assertHaveAtMost(this.info, (Iterable)this.actual, times, condition);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S doNotHaveAtMost(int times, Condition<? super T> condition) {
        this.iterables.assertDoNotHaveAtMost(this.info, (Iterable)this.actual, times, condition);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S haveExactly(int times, Condition<? super T> condition) {
        this.iterables.assertHaveExactly(this.info, (Iterable)this.actual, times, condition);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S doNotHaveExactly(int times, Condition<? super T> condition) {
        this.iterables.assertDoNotHaveExactly(this.info, (Iterable)this.actual, times, condition);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S containsAll(Iterable<? extends T> iterable) {
        this.iterables.assertContainsAll(this.info, (Iterable)this.actual, iterable);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S usingElementComparator(Comparator<? super T> customComparator) {
        this.iterables = new Iterables(new ComparatorBasedComparisonStrategy(customComparator));
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S usingDefaultElementComparator() {
        this.iterables = Iterables.instance();
        return (S)((AbstractIterableAssert)this.myself);
    }
}

