/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.data;

import org.fest.util.Objects;
import org.fest.util.Preconditions;

public class Offset<T extends Number> {
    public final T value;

    public static Offset<Double> offset(Double value) {
        Preconditions.checkNotNull((Object)value);
        if (value < 0.0) {
            throw Offset.valueNotPositive();
        }
        return new Offset<Double>(value);
    }

    public static Offset<Float> offset(Float value) {
        Preconditions.checkNotNull((Object)value);
        if (value.floatValue() < 0.0f) {
            throw Offset.valueNotPositive();
        }
        return new Offset<Float>(value);
    }

    public static Offset<Integer> offset(Integer value) {
        Preconditions.checkNotNull((Object)value);
        if (value < 0) {
            throw Offset.valueNotPositive();
        }
        return new Offset<Integer>(value);
    }

    private static IllegalArgumentException valueNotPositive() {
        return new IllegalArgumentException("The value of the offset should be greater than zero");
    }

    private Offset(T value) {
        this.value = value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Offset other = (Offset)obj;
        return Objects.areEqual(this.value, other.value);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCodeFor(this.value);
        return result;
    }

    public String toString() {
        return String.format("%s[value=%s]", this.getClass().getSimpleName(), this.value);
    }
}

