/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import hudson.remoting.Channel;
import hudson.remoting.Command;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

final class ProxyWriter
extends Writer {
    private Channel channel;
    private int oid;
    private CharArrayWriter tmp;
    private boolean closed;

    public ProxyWriter() {
    }

    public ProxyWriter(Channel channel, int oid) throws IOException {
        this.connect(channel, oid);
    }

    synchronized void connect(Channel channel, int oid) throws IOException {
        if (this.channel != null) {
            throw new IllegalStateException("Cannot connect twice");
        }
        this.channel = channel;
        this.oid = oid;
        if (this.tmp != null) {
            this.write(this.tmp.toCharArray());
            this.tmp = null;
        }
        if (this.closed) {
            this.close();
        }
    }

    public void write(int c) throws IOException {
        this.write(new char[]{(char)c}, 0, 1);
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("stream is already closed");
        }
        if (off == 0 && len == cbuf.length) {
            this.write(cbuf);
        } else {
            char[] buf = new char[len];
            System.arraycopy(cbuf, off, buf, 0, len);
            this.write(buf);
        }
    }

    public synchronized void write(char[] cbuf) throws IOException {
        if (this.closed) {
            throw new IOException("stream is already closed");
        }
        if (this.channel == null) {
            if (this.tmp == null) {
                this.tmp = new CharArrayWriter();
            }
            this.tmp.write(cbuf);
        } else {
            this.channel.send(new Chunk(this.oid, cbuf));
        }
    }

    public void flush() throws IOException {
    }

    public synchronized void close() throws IOException {
        this.closed = true;
        if (this.channel != null) {
            this.channel.send(new EOF(this.oid));
            this.channel = null;
            this.oid = -1;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    private static final class EOF
    extends Command {
        private final int oid;
        private static final long serialVersionUID = 1L;

        public EOF(int oid) {
            this.oid = oid;
        }

        protected void execute(Channel channel) {
            OutputStream os = (OutputStream)channel.getExportedObject(this.oid);
            channel.unexport(this.oid);
            try {
                os.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public String toString() {
            return "Pipe.EOF(" + this.oid + ")";
        }
    }

    private static final class Chunk
    extends Command {
        private final int oid;
        private final char[] buf;
        private static final long serialVersionUID = 1L;

        public Chunk(int oid, char[] buf) {
            this.oid = oid;
            this.buf = buf;
        }

        protected void execute(Channel channel) {
            Writer os = (Writer)channel.getExportedObject(this.oid);
            try {
                os.write(this.buf);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public String toString() {
            return "Pipe.Chunk(" + this.oid + "," + this.buf.length + ")";
        }
    }
}

