/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.websocket.common.WebSocketSession;
import org.eclipse.jetty.websocket.common.WebSocketSessionListener;

public class SessionTracker
extends AbstractLifeCycle
implements WebSocketSessionListener {
    private CopyOnWriteArraySet<WebSocketSession> sessions = new CopyOnWriteArraySet();

    public Set<WebSocketSession> getSessions() {
        return Collections.unmodifiableSet(this.sessions);
    }

    @Override
    public void onSessionOpened(WebSocketSession session) {
        this.sessions.add(session);
    }

    @Override
    public void onSessionClosed(WebSocketSession session) {
        this.sessions.remove(session);
    }

    protected void doStop() throws Exception {
        for (WebSocketSession session : this.sessions) {
            LifeCycle.stop((Object)session);
        }
        super.doStop();
    }
}

