/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.http.server;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.http.server.AsIsFileFilter;
import org.eclipse.jgit.http.server.HttpServerText;
import org.eclipse.jgit.http.server.InfoPacksServlet;
import org.eclipse.jgit.http.server.InfoRefsServlet;
import org.eclipse.jgit.http.server.IsLocalFilter;
import org.eclipse.jgit.http.server.NoCacheFilter;
import org.eclipse.jgit.http.server.ObjectFileServlet;
import org.eclipse.jgit.http.server.ReceivePackErrorHandler;
import org.eclipse.jgit.http.server.ReceivePackServlet;
import org.eclipse.jgit.http.server.RepositoryFilter;
import org.eclipse.jgit.http.server.TextFileServlet;
import org.eclipse.jgit.http.server.UploadPackErrorHandler;
import org.eclipse.jgit.http.server.UploadPackServlet;
import org.eclipse.jgit.http.server.glue.ErrorServlet;
import org.eclipse.jgit.http.server.glue.MetaFilter;
import org.eclipse.jgit.http.server.glue.RegexGroupFilter;
import org.eclipse.jgit.http.server.glue.ServletBinder;
import org.eclipse.jgit.http.server.resolver.AsIsFileService;
import org.eclipse.jgit.http.server.resolver.DefaultReceivePackFactory;
import org.eclipse.jgit.http.server.resolver.DefaultUploadPackFactory;
import org.eclipse.jgit.transport.resolver.FileResolver;
import org.eclipse.jgit.transport.resolver.ReceivePackFactory;
import org.eclipse.jgit.transport.resolver.RepositoryResolver;
import org.eclipse.jgit.transport.resolver.UploadPackFactory;
import org.eclipse.jgit.util.StringUtils;

public class GitFilter
extends MetaFilter {
    private volatile boolean initialized;
    private RepositoryResolver<HttpServletRequest> resolver;
    private AsIsFileService asIs = new AsIsFileService();
    private UploadPackFactory<HttpServletRequest> uploadPackFactory = new DefaultUploadPackFactory();
    private UploadPackErrorHandler uploadPackErrorHandler;
    private ReceivePackFactory<HttpServletRequest> receivePackFactory = new DefaultReceivePackFactory();
    private ReceivePackErrorHandler receivePackErrorHandler;
    private final List<Filter> uploadPackFilters = new ArrayList<Filter>();
    private final List<Filter> receivePackFilters = new ArrayList<Filter>();

    public void setRepositoryResolver(RepositoryResolver<HttpServletRequest> resolver) {
        this.assertNotInitialized();
        this.resolver = resolver;
    }

    public void setAsIsFileService(AsIsFileService f) {
        this.assertNotInitialized();
        this.asIs = f != null ? f : AsIsFileService.DISABLED;
    }

    public void setUploadPackFactory(UploadPackFactory<HttpServletRequest> f) {
        this.assertNotInitialized();
        this.uploadPackFactory = f != null ? f : UploadPackFactory.DISABLED;
    }

    public void setUploadPackErrorHandler(UploadPackErrorHandler h) {
        this.assertNotInitialized();
        this.uploadPackErrorHandler = h;
    }

    public void addUploadPackFilter(Filter filter) {
        this.assertNotInitialized();
        this.uploadPackFilters.add(filter);
    }

    public void setReceivePackFactory(ReceivePackFactory<HttpServletRequest> f) {
        this.assertNotInitialized();
        this.receivePackFactory = f != null ? f : ReceivePackFactory.DISABLED;
    }

    public void setReceivePackErrorHandler(ReceivePackErrorHandler h) {
        this.assertNotInitialized();
        this.receivePackErrorHandler = h;
    }

    public void addReceivePackFilter(Filter filter) {
        this.assertNotInitialized();
        this.receivePackFilters.add(filter);
    }

    private void assertNotInitialized() {
        if (this.initialized) {
            throw new IllegalStateException(HttpServerText.get().alreadyInitializedByContainer);
        }
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        ServletBinder b;
        super.init(filterConfig);
        if (this.resolver == null) {
            File root = GitFilter.getFile(filterConfig, "base-path");
            boolean exportAll = GitFilter.getBoolean(filterConfig, "export-all");
            this.setRepositoryResolver((RepositoryResolver<HttpServletRequest>)new FileResolver(root, exportAll));
        }
        this.initialized = true;
        if (this.uploadPackFactory != UploadPackFactory.DISABLED) {
            b = this.serve("*/git-upload-pack");
            b = b.through(new UploadPackServlet.Factory(this.uploadPackFactory));
            for (Filter f : this.uploadPackFilters) {
                b = b.through(f);
            }
            b.with(new UploadPackServlet(this.uploadPackErrorHandler));
        }
        if (this.receivePackFactory != ReceivePackFactory.DISABLED) {
            b = this.serve("*/git-receive-pack");
            b = b.through(new ReceivePackServlet.Factory(this.receivePackFactory));
            for (Filter f : this.receivePackFilters) {
                b = b.through(f);
            }
            b.with(new ReceivePackServlet(this.receivePackErrorHandler));
        }
        ServletBinder refs = this.serve("*/info/refs");
        if (this.uploadPackFactory != UploadPackFactory.DISABLED) {
            refs = refs.through(new UploadPackServlet.InfoRefs(this.uploadPackFactory, this.uploadPackFilters));
        }
        if (this.receivePackFactory != ReceivePackFactory.DISABLED) {
            refs = refs.through(new ReceivePackServlet.InfoRefs(this.receivePackFactory, this.receivePackFilters));
        }
        if (this.asIs != AsIsFileService.DISABLED) {
            refs = refs.through(new IsLocalFilter());
            refs = refs.through(new AsIsFileFilter(this.asIs));
            refs.with(new InfoRefsServlet());
        } else {
            refs.with(new ErrorServlet(406));
        }
        if (this.asIs != AsIsFileService.DISABLED) {
            IsLocalFilter mustBeLocal = new IsLocalFilter();
            AsIsFileFilter enabled = new AsIsFileFilter(this.asIs);
            this.serve("*/HEAD").through(mustBeLocal).through(enabled).with(new TextFileServlet("HEAD"));
            String info_alternates = "objects/info/alternates";
            this.serve("*/objects/info/alternates").through(mustBeLocal).through(enabled).with(new TextFileServlet("objects/info/alternates"));
            String http_alternates = "objects/info/http-alternates";
            this.serve("*/objects/info/http-alternates").through(mustBeLocal).through(enabled).with(new TextFileServlet("objects/info/http-alternates"));
            this.serve("*/objects/info/packs").through(mustBeLocal).through(enabled).with(new InfoPacksServlet());
            this.serveRegex("^/(.*)/objects/([0-9a-f]{2}/[0-9a-f]{38})$").through(mustBeLocal).through(enabled).through(new RegexGroupFilter(2)).with(new ObjectFileServlet.Loose());
            this.serveRegex("^/(.*)/objects/(pack/pack-[0-9a-f]{40}\\.pack)$").through(mustBeLocal).through(enabled).through(new RegexGroupFilter(2)).with(new ObjectFileServlet.Pack());
            this.serveRegex("^/(.*)/objects/(pack/pack-[0-9a-f]{40}\\.idx)$").through(mustBeLocal).through(enabled).through(new RegexGroupFilter(2)).with(new ObjectFileServlet.PackIdx());
        }
    }

    private static File getFile(FilterConfig cfg, String param) throws ServletException {
        String n = cfg.getInitParameter(param);
        if (n == null || "".equals(n)) {
            throw new ServletException(MessageFormat.format(HttpServerText.get().parameterNotSet, param));
        }
        File path = new File(n);
        if (!path.exists()) {
            throw new ServletException(MessageFormat.format(HttpServerText.get().pathForParamNotFound, path, param));
        }
        return path;
    }

    private static boolean getBoolean(FilterConfig cfg, String param) throws ServletException {
        String n = cfg.getInitParameter(param);
        if (n == null) {
            return false;
        }
        try {
            return StringUtils.toBoolean((String)n);
        }
        catch (IllegalArgumentException err) {
            throw new ServletException(MessageFormat.format(HttpServerText.get().invalidBoolean, param, n), (Throwable)err);
        }
    }

    @Override
    protected ServletBinder register(ServletBinder binder) {
        if (this.resolver == null) {
            throw new IllegalStateException(HttpServerText.get().noResolverAvailable);
        }
        binder = binder.through(new NoCacheFilter());
        binder = binder.through(new RepositoryFilter(this.resolver));
        return binder;
    }
}

