/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.util.List;
import java.util.Map;
import org.eclipse.jgit.merge.ResolveMerger;
import org.eclipse.jgit.revwalk.RevCommit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RebaseResult {
    static final RebaseResult OK_RESULT = new RebaseResult(Status.OK);
    static final RebaseResult ABORTED_RESULT = new RebaseResult(Status.ABORTED);
    static final RebaseResult UP_TO_DATE_RESULT = new RebaseResult(Status.UP_TO_DATE);
    static final RebaseResult FAST_FORWARD_RESULT = new RebaseResult(Status.FAST_FORWARD);
    static final RebaseResult NOTHING_TO_COMMIT_RESULT = new RebaseResult(Status.NOTHING_TO_COMMIT);
    static final RebaseResult INTERACTIVE_PREPARED_RESULT = new RebaseResult(Status.INTERACTIVE_PREPARED);
    static final RebaseResult STASH_APPLY_CONFLICTS_RESULT = new RebaseResult(Status.STASH_APPLY_CONFLICTS);
    private final Status status;
    private final RevCommit currentCommit;
    private Map<String, ResolveMerger.MergeFailureReason> failingPaths;
    private List<String> conflicts;
    private List<String> uncommittedChanges;

    private RebaseResult(Status status) {
        this.status = status;
        this.currentCommit = null;
    }

    private RebaseResult(Status status, RevCommit commit) {
        this.status = status;
        this.currentCommit = commit;
    }

    static RebaseResult result(Status status, RevCommit commit) {
        return new RebaseResult(status, commit);
    }

    static RebaseResult failed(Map<String, ResolveMerger.MergeFailureReason> failingPaths) {
        RebaseResult result = new RebaseResult(Status.FAILED);
        result.failingPaths = failingPaths;
        return result;
    }

    static RebaseResult conflicts(List<String> conflicts) {
        RebaseResult result = new RebaseResult(Status.CONFLICTS);
        result.conflicts = conflicts;
        return result;
    }

    static RebaseResult uncommittedChanges(List<String> uncommittedChanges) {
        RebaseResult result = new RebaseResult(Status.UNCOMMITTED_CHANGES);
        result.uncommittedChanges = uncommittedChanges;
        return result;
    }

    public Status getStatus() {
        return this.status;
    }

    public RevCommit getCurrentCommit() {
        return this.currentCommit;
    }

    public Map<String, ResolveMerger.MergeFailureReason> getFailingPaths() {
        return this.failingPaths;
    }

    public List<String> getConflicts() {
        return this.conflicts;
    }

    public List<String> getUncommittedChanges() {
        return this.uncommittedChanges;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        OK{

            public boolean isSuccessful() {
                return true;
            }
        }
        ,
        ABORTED{

            public boolean isSuccessful() {
                return false;
            }
        }
        ,
        STOPPED{

            public boolean isSuccessful() {
                return false;
            }
        }
        ,
        EDIT{

            public boolean isSuccessful() {
                return false;
            }
        }
        ,
        FAILED{

            public boolean isSuccessful() {
                return false;
            }
        }
        ,
        UNCOMMITTED_CHANGES{

            public boolean isSuccessful() {
                return false;
            }
        }
        ,
        CONFLICTS{

            public boolean isSuccessful() {
                return false;
            }
        }
        ,
        UP_TO_DATE{

            public boolean isSuccessful() {
                return true;
            }
        }
        ,
        FAST_FORWARD{

            public boolean isSuccessful() {
                return true;
            }
        }
        ,
        NOTHING_TO_COMMIT{

            public boolean isSuccessful() {
                return false;
            }
        }
        ,
        INTERACTIVE_PREPARED{

            public boolean isSuccessful() {
                return false;
            }
        }
        ,
        STASH_APPLY_CONFLICTS{

            public boolean isSuccessful() {
                return true;
            }
        };


        public abstract boolean isSuccessful();
    }
}

