/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.impl.resolver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.equinox.internal.p2.director.Explanation;
import org.eclipse.equinox.internal.p2.director.Projector;
import org.eclipse.equinox.internal.p2.director.QueryableArray;
import org.eclipse.equinox.internal.p2.director.SimplePlanner;
import org.eclipse.equinox.internal.p2.director.Slicer;
import org.eclipse.equinox.internal.p2.metadata.InstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.tycho.core.facade.MavenLogger;
import org.eclipse.tycho.p2.impl.resolver.AbstractSlicerResolutionStrategy;
import org.eclipse.tycho.p2.impl.resolver.QueryableCollection;
import org.eclipse.tycho.p2.impl.resolver.ResolverDebugUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectorResolutionStrategy
extends AbstractSlicerResolutionStrategy {
    public ProjectorResolutionStrategy(MavenLogger logger) {
        super(logger);
    }

    @Override
    protected Slicer newSlicer(IQueryable<IInstallableUnit> availableUnits, Map<String, String> properties) {
        return new Slicer(availableUnits, properties, false);
    }

    @Override
    protected boolean isSlicerError(MultiStatus slicerStatus) {
        return slicerStatus.matches(12);
    }

    @Override
    public Collection<IInstallableUnit> resolve(Map<String, String> properties, IProgressMonitor monitor) {
        properties = this.addFeatureJarFilter(properties);
        Map newSelectionContext = SimplePlanner.createSelectionContext(properties);
        IQueryable<IInstallableUnit> slice = this.slice(properties, monitor);
        LinkedHashSet<IInstallableUnit> rootIUs = new LinkedHashSet<IInstallableUnit>(this.rootIUs);
        rootIUs.addAll(this.jreIUs);
        Projector projector = new Projector(slice, newSelectionContext, new HashSet(), false);
        projector.encode(this.createMetaIU(rootIUs), EMPTY_IU_ARRAY, (IQueryable)new QueryableArray(EMPTY_IU_ARRAY), rootIUs, monitor);
        IStatus s = projector.invokeSolver(monitor);
        if (s.getSeverity() == 4) {
            Set explanation = projector.getExplanation(monitor);
            this.logger.info(newSelectionContext.toString());
            this.logger.error("Cannot resolve project dependencies:");
            for (Explanation explanationLine : explanation) {
                this.logger.error("  " + explanationLine.toString());
            }
            this.logger.error("");
            throw this.newResolutionException(s);
        }
        Collection newState = projector.extractSolution();
        newState.removeAll(this.jreIUs);
        this.fixSWT((IQueryable<IInstallableUnit>)new QueryableCollection(this.availableIUs), newState, newSelectionContext, monitor);
        if (this.logger.isExtendedDebugEnabled()) {
            this.logger.debug("Resolved IUs:\n" + ResolverDebugUtils.toDebugString(newState, false));
        }
        return newState;
    }

    private void fixSWT(IQueryable<IInstallableUnit> availableIUs, Collection<IInstallableUnit> ius, Map<String, String> newSelectionContext, IProgressMonitor monitor) {
        boolean swt = false;
        for (IInstallableUnit iu : ius) {
            if (!"org.eclipse.swt".equals(iu.getId())) continue;
            swt = true;
            break;
        }
        if (!swt) {
            return;
        }
        IInstallableUnit swtFragment = null;
        block1: for (IInstallableUnit iu : availableIUs.query(QueryUtil.ALL_UNITS, monitor)) {
            if (!iu.getId().startsWith("org.eclipse.swt") || !this.isApplicable(newSelectionContext, (IMatchExpression<IInstallableUnit>)iu.getFilter())) continue;
            for (IProvidedCapability provided : iu.getProvidedCapabilities()) {
                if (!"osgi.fragment".equals(provided.getNamespace()) || !"org.eclipse.swt".equals(provided.getName())) continue;
                if (swtFragment != null && swtFragment.getVersion().compareTo((Object)iu.getVersion()) >= 0) continue block1;
                swtFragment = iu;
                continue block1;
            }
        }
        if (swtFragment == null) {
            throw new RuntimeException("Could not determine SWT implementation fragment bundle");
        }
        ius.add(swtFragment);
    }

    protected boolean isApplicable(Map<String, String> selectionContext, IMatchExpression<IInstallableUnit> filter) {
        if (filter == null) {
            return true;
        }
        return filter.isMatch((Object)InstallableUnit.contextIU(selectionContext));
    }

    private IInstallableUnit createMetaIU(Set<IInstallableUnit> rootIUs) {
        MetadataFactory.InstallableUnitDescription iud = new MetadataFactory.InstallableUnitDescription();
        String time = Long.toString(System.currentTimeMillis());
        iud.setId("tycho-" + time);
        iud.setVersion(Version.createOSGi((int)0, (int)0, (int)0, (String)time));
        ArrayList<IRequirement> requirements = new ArrayList<IRequirement>();
        for (IInstallableUnit iu : rootIUs) {
            VersionRange range = new VersionRange(iu.getVersion(), true, iu.getVersion(), true);
            requirements.add(MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)iu.getId(), (VersionRange)range, (IMatchExpression)iu.getFilter(), (int)1, (int)(iu.isSingleton() ? 1 : Integer.MAX_VALUE), (boolean)true));
        }
        if (this.additionalRequirements != null) {
            requirements.addAll(this.additionalRequirements);
        }
        iud.setRequirements(requirements.toArray(new IRequirement[requirements.size()]));
        return MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iud);
    }
}

