/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import java.io.IOException;
import java.util.Collections;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FieldFilterLeafReader;
import org.apache.lucene.index.FilterDirectoryReader;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;

public class FieldMaskingReader
extends FilterDirectoryReader {
    private final String field;

    public FieldMaskingReader(final String field, DirectoryReader in) throws IOException {
        super(in, new FilterDirectoryReader.SubReaderWrapper(){

            public LeafReader wrap(final LeafReader reader) {
                return new FilterLeafReader((LeafReader)new FieldFilterLeafReader(reader, Collections.singleton(field), true)){

                    public IndexReader.CacheHelper getReaderCacheHelper() {
                        return reader.getReaderCacheHelper();
                    }

                    public IndexReader.CacheHelper getCoreCacheHelper() {
                        return reader.getCoreCacheHelper();
                    }
                };
            }
        });
        this.field = field;
    }

    protected DirectoryReader doWrapDirectoryReader(DirectoryReader in) throws IOException {
        return new FieldMaskingReader(this.field, in);
    }

    public IndexReader.CacheHelper getReaderCacheHelper() {
        return this.in.getReaderCacheHelper();
    }
}

