/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.net.InetSocketAddress;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.concurrent.CompletableContext;
import org.elasticsearch.transport.TcpChannel;

public class FakeTcpChannel
implements TcpChannel {
    private final boolean isServer;
    private final String profile;
    private final AtomicReference<BytesReference> messageCaptor;
    private final TcpChannel.ChannelStats stats = new TcpChannel.ChannelStats();
    private final CompletableContext<Void> closeContext = new CompletableContext();

    public FakeTcpChannel() {
        this(false, "profile", new AtomicReference<BytesReference>());
    }

    public FakeTcpChannel(boolean isServer) {
        this(isServer, "profile", new AtomicReference<BytesReference>());
    }

    public FakeTcpChannel(boolean isServer, AtomicReference<BytesReference> messageCaptor) {
        this(isServer, "profile", messageCaptor);
    }

    public FakeTcpChannel(boolean isServer, String profile, AtomicReference<BytesReference> messageCaptor) {
        this.isServer = isServer;
        this.profile = profile;
        this.messageCaptor = messageCaptor;
    }

    public boolean isServerChannel() {
        return this.isServer;
    }

    public String getProfile() {
        return this.profile;
    }

    public InetSocketAddress getLocalAddress() {
        return null;
    }

    public InetSocketAddress getRemoteAddress() {
        return null;
    }

    public void sendMessage(BytesReference reference, ActionListener<Void> listener) {
        this.messageCaptor.set(reference);
    }

    public void addConnectListener(ActionListener<Void> listener) {
    }

    public void close() {
        this.closeContext.complete(null);
    }

    public void addCloseListener(ActionListener<Void> listener) {
        this.closeContext.addListener(ActionListener.toBiConsumer(listener));
    }

    public boolean isOpen() {
        return !this.closeContext.isDone();
    }

    public TcpChannel.ChannelStats getChannelStats() {
        return this.stats;
    }
}

