/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.audit.repository;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.ff4j.audit.Event;
import org.ff4j.audit.EventQueryDefinition;
import org.ff4j.audit.EventSeries;
import org.ff4j.audit.MutableHitCount;
import org.ff4j.audit.chart.TimeSeriesChart;
import org.ff4j.audit.repository.AbstractEventRepository;
import org.ff4j.exception.AuditAccessException;
import org.ff4j.exception.FeatureAccessException;
import org.ff4j.store.JdbcEventMapper;
import org.ff4j.store.JdbcQueryBuilder;
import org.ff4j.utils.JdbcUtils;
import org.ff4j.utils.MappingUtil;
import org.ff4j.utils.Util;

public class JdbcEventRepository
extends AbstractEventRepository {
    public static final String CANNOT_READ_AUDITTABLE = "Cannot read audit table from DB";
    public static final String CANNOT_BUILD_PIE_CHART_FROM_REPOSITORY = "Cannot build PieChart from repository, ";
    private DataSource dataSource;
    private JdbcQueryBuilder queryBuilder;
    private static final JdbcEventMapper EVENT_MAPPER = new JdbcEventMapper();

    public JdbcEventRepository(DataSource jdbcDS) {
        this.dataSource = jdbcDS;
    }

    @Override
    public void createSchema() {
        JdbcQueryBuilder qb;
        DataSource ds = this.getDataSource();
        if (!JdbcUtils.isTableExist(ds, (qb = this.getQueryBuilder()).getTableNameAudit())) {
            JdbcUtils.executeUpdate(ds, qb.sqlCreateTableAudit());
        }
    }

    @Override
    public boolean saveEvent(Event evt) {
        Util.assertEvent(evt);
        Connection sqlConn = null;
        PreparedStatement stmt = null;
        try {
            sqlConn = this.dataSource.getConnection();
            sqlConn.setAutoCommit(false);
            int idx = 9;
            HashMap<Integer, String> statementParams = new HashMap<Integer, String>();
            StringBuilder sb = new StringBuilder("INSERT INTO " + this.getQueryBuilder().getTableNameAudit() + "(EVT_UUID,EVT_TIME,EVT_TYPE,EVT_NAME,EVT_ACTION,EVT_HOSTNAME,EVT_SOURCE,EVT_DURATION");
            if (Util.hasLength(evt.getUser())) {
                sb.append(", EVT_USER");
                statementParams.put(idx, evt.getUser());
                ++idx;
            }
            if (Util.hasLength(evt.getValue())) {
                sb.append(", EVT_VALUE");
                statementParams.put(idx, evt.getValue());
                ++idx;
            }
            if (!evt.getCustomKeys().isEmpty()) {
                sb.append(", EVT_KEYS");
                statementParams.put(idx, MappingUtil.fromMap(evt.getCustomKeys()));
                ++idx;
            }
            sb.append(") VALUES (?");
            for (int offset = 1; offset < idx - 1; ++offset) {
                sb.append(",?");
            }
            sb.append(")");
            stmt = sqlConn.prepareStatement(sb.toString());
            stmt.setString(1, evt.getUuid());
            stmt.setTimestamp(2, new Timestamp(evt.getTimestamp()));
            stmt.setString(3, evt.getType());
            stmt.setString(4, evt.getName());
            stmt.setString(5, evt.getAction());
            stmt.setString(6, evt.getHostName());
            stmt.setString(7, evt.getSource());
            stmt.setLong(8, evt.getDuration());
            for (int id = 9; id < idx; ++id) {
                stmt.setString(id, (String)statementParams.get(id));
            }
            stmt.executeUpdate();
            sqlConn.commit();
        }
        catch (Exception exc) {
            try {
                throw new AuditAccessException("Cannot insert event into DB (" + exc.getClass() + ") " + exc.getCause(), exc);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(stmt);
                JdbcUtils.closeConnection(sqlConn);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(stmt);
        JdbcUtils.closeConnection(sqlConn);
        return true;
    }

    @Override
    public Event getEventByUUID(String uuid, Long timestamp) {
        Event event;
        ResultSet rs;
        PreparedStatement ps;
        Connection sqlConn;
        block5: {
            Util.assertHasLength(uuid);
            sqlConn = null;
            ps = null;
            rs = null;
            sqlConn = this.getDataSource().getConnection();
            ps = sqlConn.prepareStatement(this.getQueryBuilder().getEventByUuidQuery());
            ps.setString(1, uuid);
            rs = ps.executeQuery();
            if (!rs.next()) break block5;
            Event event2 = EVENT_MAPPER.mapEvent(rs);
            JdbcUtils.closeResultSet(rs);
            JdbcUtils.closeStatement(ps);
            JdbcUtils.closeConnection(sqlConn);
            return event2;
        }
        try {
            event = null;
        }
        catch (SQLException sqlEX) {
            try {
                throw new IllegalStateException("CANNOT_READ_AUDITTABLE", sqlEX);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeResultSet(rs);
                JdbcUtils.closeStatement(ps);
                JdbcUtils.closeConnection(sqlConn);
                throw throwable;
            }
        }
        JdbcUtils.closeResultSet(rs);
        JdbcUtils.closeStatement(ps);
        JdbcUtils.closeConnection(sqlConn);
        return event;
    }

    @Override
    public void purgeAuditTrail(EventQueryDefinition qDef) {
        Util.assertNotNull(qDef);
        Connection sqlConn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            sqlConn = this.getDataSource().getConnection();
            ps = sqlConn.prepareStatement(this.getQueryBuilder().getPurgeAuditTrailQuery(qDef));
            ps.setTimestamp(1, new Timestamp(qDef.getFrom()));
            ps.setTimestamp(2, new Timestamp(qDef.getTo()));
            ps.executeUpdate();
        }
        catch (SQLException sqlEX) {
            try {
                throw new IllegalStateException("CANNOT_READ_AUDITTABLE", sqlEX);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeResultSet(rs);
                JdbcUtils.closeStatement(ps);
                JdbcUtils.closeConnection(sqlConn);
                throw throwable;
            }
        }
        JdbcUtils.closeResultSet(rs);
        JdbcUtils.closeStatement(ps);
        JdbcUtils.closeConnection(sqlConn);
    }

    @Override
    public void purgeFeatureUsage(EventQueryDefinition qDef) {
        Util.assertNotNull(qDef);
        Connection sqlConn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            sqlConn = this.getDataSource().getConnection();
            ps = sqlConn.prepareStatement(this.getQueryBuilder().getPurgeFeatureUsageQuery(qDef));
            ps.setTimestamp(1, new Timestamp(qDef.getFrom()));
            ps.setTimestamp(2, new Timestamp(qDef.getTo()));
            ps.executeUpdate();
        }
        catch (SQLException sqlEX) {
            try {
                throw new IllegalStateException("CANNOT_READ_AUDITTABLE", sqlEX);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeResultSet(rs);
                JdbcUtils.closeStatement(ps);
                JdbcUtils.closeConnection(sqlConn);
                throw throwable;
            }
        }
        JdbcUtils.closeResultSet(rs);
        JdbcUtils.closeStatement(ps);
        JdbcUtils.closeConnection(sqlConn);
    }

    private EventSeries searchEvents(String sqlQuery, long from, long to) {
        Connection sqlConn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        EventSeries es = new EventSeries();
        try {
            sqlConn = this.getDataSource().getConnection();
            ps = sqlConn.prepareStatement(sqlQuery);
            ps.setTimestamp(1, new Timestamp(from));
            ps.setTimestamp(2, new Timestamp(to));
            rs = ps.executeQuery();
            while (rs.next()) {
                es.add(EVENT_MAPPER.mapEvent(rs));
            }
        }
        catch (SQLException sqlEX) {
            try {
                throw new IllegalStateException("CANNOT_READ_AUDITTABLE", sqlEX);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeResultSet(rs);
                JdbcUtils.closeStatement(ps);
                JdbcUtils.closeConnection(sqlConn);
                throw throwable;
            }
        }
        JdbcUtils.closeResultSet(rs);
        JdbcUtils.closeStatement(ps);
        JdbcUtils.closeConnection(sqlConn);
        return es;
    }

    private Map<String, MutableHitCount> computeHitCount(String sqlQuery, String columnName, long from, long to) {
        Connection sqlConn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        HashMap<String, MutableHitCount> hitCount = new HashMap<String, MutableHitCount>();
        try {
            sqlConn = this.dataSource.getConnection();
            ps = sqlConn.prepareStatement(sqlQuery);
            ps.setTimestamp(1, new Timestamp(from));
            ps.setTimestamp(2, new Timestamp(to));
            rs = ps.executeQuery();
            while (rs.next()) {
                hitCount.put(rs.getString(columnName), new MutableHitCount(rs.getInt("NB")));
            }
        }
        catch (SQLException sqlEX) {
            try {
                throw new FeatureAccessException(CANNOT_BUILD_PIE_CHART_FROM_REPOSITORY, sqlEX);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeResultSet(rs);
                JdbcUtils.closeStatement(ps);
                JdbcUtils.closeConnection(sqlConn);
                throw throwable;
            }
        }
        JdbcUtils.closeResultSet(rs);
        JdbcUtils.closeStatement(ps);
        JdbcUtils.closeConnection(sqlConn);
        return hitCount;
    }

    @Override
    public EventSeries getAuditTrail(EventQueryDefinition qDef) {
        return this.searchEvents(this.getQueryBuilder().getSelectAuditTrailQuery(qDef), qDef.getFrom(), qDef.getTo());
    }

    @Override
    public EventSeries searchFeatureUsageEvents(EventQueryDefinition qDef) {
        return this.searchEvents(this.getQueryBuilder().getSelectFeatureUsageQuery(qDef), qDef.getFrom(), qDef.getTo());
    }

    @Override
    public Map<String, MutableHitCount> getFeatureUsageHitCount(EventQueryDefinition query) {
        return this.computeHitCount(this.getQueryBuilder().getFeaturesHitCount(), "EVT_NAME", query.getFrom(), query.getTo());
    }

    @Override
    public Map<String, MutableHitCount> getHostHitCount(EventQueryDefinition query) {
        return this.computeHitCount(this.getQueryBuilder().getHostHitCount(), "EVT_HOSTNAME", query.getFrom(), query.getTo());
    }

    @Override
    public Map<String, MutableHitCount> getUserHitCount(EventQueryDefinition query) {
        return this.computeHitCount(this.getQueryBuilder().getUserHitCount(), "EVT_USER", query.getFrom(), query.getTo());
    }

    @Override
    public Map<String, MutableHitCount> getSourceHitCount(EventQueryDefinition query) {
        return this.computeHitCount(this.getQueryBuilder().getSourceHitCount(), "EVT_SOURCE", query.getFrom(), query.getTo());
    }

    @Override
    public TimeSeriesChart getFeatureUsageHistory(EventQueryDefinition query, TimeUnit units) {
        TimeSeriesChart tsc = new TimeSeriesChart(query.getFrom(), query.getTo(), units);
        Iterator iterEvent = this.searchFeatureUsageEvents(query).iterator();
        while (iterEvent.hasNext()) {
            tsc.addEvent((Event)iterEvent.next());
        }
        return tsc;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public JdbcQueryBuilder getQueryBuilder() {
        if (this.queryBuilder == null) {
            this.queryBuilder = new JdbcQueryBuilder();
        }
        return this.queryBuilder;
    }

    public void setQueryBuilder(JdbcQueryBuilder queryBuilder) {
        this.queryBuilder = queryBuilder;
    }
}

