/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.property;

import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.ff4j.property.util.PropertyJsonBean;
import org.ff4j.utils.Util;

public abstract class Property<T>
implements Serializable {
    private static final long serialVersionUID = 4987351300418126366L;
    protected boolean readOnly = false;
    protected String name;
    protected String description = null;
    protected String type = this.getClass().getCanonicalName();
    protected T value;
    protected Set<T> fixedValues;

    protected Property() {
    }

    protected Property(String name) {
        Util.assertHasLength(name);
        this.name = name;
    }

    protected Property(String name, String value) {
        this(name);
        this.value = this.fromString(value);
    }

    protected Property(String name, T value, Set<T> fixed) {
        this(name);
        this.value = value;
        this.fixedValues = fixed;
        if (this.fixedValues != null && !this.fixedValues.isEmpty() && !this.fixedValues.contains(value)) {
            throw new IllegalArgumentException("Invalid value corrects are " + this.fixedValues);
        }
    }

    protected Property(String name, T value, T ... fixed) {
        this(name, value, (Set<T>)new HashSet<T>(Arrays.asList(fixed)));
    }

    public void add2FixedValueFromString(String v) {
        this.add2FixedValue(this.fromString(v));
    }

    public void add2FixedValue(T value) {
        if (this.fixedValues == null) {
            this.fixedValues = new HashSet<T>();
        }
        this.fixedValues.add(value);
    }

    public abstract T fromString(String var1);

    public Class<T> parameterizedType() {
        ParameterizedType pt = (ParameterizedType)this.getClass().getGenericSuperclass();
        return (Class)pt.getActualTypeArguments()[0];
    }

    public String asString() {
        if (this.value == null) {
            return null;
        }
        return this.value.toString();
    }

    public int asInt() {
        return Integer.parseInt(this.asString());
    }

    public double asDouble() {
        return Double.parseDouble(this.asString());
    }

    public boolean asBoolean() {
        return Boolean.parseBoolean(this.asString());
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public void setValueFromString(String value) {
        this.value = this.fromString(value);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Set<T> getFixedValues() {
        return this.fixedValues;
    }

    public void setFixedValues(Set<T> fixedValues) {
        this.fixedValues = fixedValues;
    }

    public String toString() {
        return this.toJson();
    }

    public String toJson() {
        return new PropertyJsonBean(this).asJson();
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }
}

