/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.store;

import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.ff4j.conf.XmlConfig;
import org.ff4j.conf.XmlParser;
import org.ff4j.core.Feature;
import org.ff4j.core.FeatureStore;
import org.ff4j.exception.FeatureAlreadyExistException;
import org.ff4j.exception.FeatureNotFoundException;
import org.ff4j.exception.GroupNotFoundException;
import org.ff4j.utils.JsonUtils;
import org.ff4j.utils.Util;

public abstract class AbstractFeatureStore
implements FeatureStore {
    public Map<String, Feature> importFeaturesFromXmlFile(String xmlConfFile) {
        if (xmlConfFile == null || xmlConfFile.isEmpty()) {
            throw new IllegalArgumentException("Configuration filename cannot be null nor empty");
        }
        InputStream xmlIS = this.getClass().getClassLoader().getResourceAsStream(xmlConfFile);
        if (xmlIS == null) {
            throw new IllegalArgumentException("File " + xmlConfFile + " could not be read, please check path and rights");
        }
        XmlConfig conf = new XmlParser().parseConfigurationFile(xmlIS);
        Map<String, Feature> features = conf.getFeatures();
        this.importFeatures(features.values());
        return features;
    }

    @Override
    public void createSchema() {
    }

    @Override
    public void importFeatures(Collection<Feature> features) {
        if (features != null) {
            for (Feature feature : features) {
                if (this.exist(feature.getUid())) {
                    this.delete(feature.getUid());
                }
                this.create(feature);
            }
        }
    }

    public String toJson() {
        StringBuilder sb = new StringBuilder("{");
        sb.append("\"type\":\"" + this.getClass().getCanonicalName() + "\"");
        sb.append(JsonUtils.cacheJson(this));
        Set<String> myFeatures = this.readAll().keySet();
        sb.append(",\"numberOfFeatures\":" + myFeatures.size());
        sb.append(",\"features\":[");
        boolean first = true;
        for (String myFeature : myFeatures) {
            if (!first) {
                sb.append(",");
            }
            first = false;
            sb.append("\"" + myFeature + "\"");
        }
        Set<String> myGroups = this.readAllGroups();
        sb.append("],\"numberOfGroups\":" + myGroups.size());
        sb.append(",\"groups\":[");
        first = true;
        for (String myGroup : myGroups) {
            if (!first) {
                sb.append(",");
            }
            first = false;
            sb.append("\"" + myGroup + "\"");
        }
        sb.append("]");
        sb.append("}");
        return sb.toString();
    }

    public String toString() {
        return this.toJson();
    }

    protected void assertFeatureExist(String uid) {
        Util.assertHasLength(uid);
        if (!this.exist(uid)) {
            throw new FeatureNotFoundException(uid);
        }
    }

    protected void assertFeatureNotExist(String uid) {
        Util.assertHasLength(uid);
        if (this.exist(uid)) {
            throw new FeatureAlreadyExistException(uid);
        }
    }

    protected void assertGroupExist(String groupName) {
        Util.assertHasLength(groupName);
        if (!this.existGroup(groupName)) {
            throw new GroupNotFoundException(groupName);
        }
    }

    protected void assertFeatureNotNull(Feature feature) {
        if (feature == null) {
            throw new IllegalArgumentException("Feature cannot be null nor empty");
        }
    }
}

