/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.strategy;

import java.io.Serializable;
import java.util.Map;
import org.ff4j.core.FeatureStore;
import org.ff4j.core.FlippingExecutionContext;
import org.ff4j.strategy.AbstractFlipStrategy;

public class PonderationStrategy
extends AbstractFlipStrategy
implements Serializable {
    private static final long serialVersionUID = -2353911851539414159L;
    private static final double HALF = 0.5;
    private static final String PARAM_WEIGHT = "weight";
    private double weight = 0.5;

    public PonderationStrategy() {
    }

    public PonderationStrategy(double threshold) {
        this.weight = threshold;
        this.checkWeight();
        this.getInitParams().put(PARAM_WEIGHT, String.valueOf(threshold));
    }

    @Override
    public void init(String featureName, Map<String, String> initParams) {
        super.init(featureName, initParams);
        if (initParams != null && initParams.containsKey(PARAM_WEIGHT)) {
            this.weight = Double.parseDouble(initParams.get(PARAM_WEIGHT));
        }
        this.checkWeight();
    }

    @Override
    public boolean evaluate(String featureName, FeatureStore currentStore, FlippingExecutionContext executionContext) {
        return Math.random() <= this.weight;
    }

    private void checkWeight() {
        if (this.weight < 0.0 || this.weight > 1.0) {
            throw new IllegalArgumentException("The ponderation value is a percentage and should be set between 0 and 1");
        }
    }

    public void setWeight(double weight) {
        this.weight = weight;
    }

    @Override
    public Map<String, String> getInitParams() {
        this.initParams.put(PARAM_WEIGHT, String.valueOf(this.weight));
        return this.initParams;
    }
}

