/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.strategy.el;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.ff4j.core.Feature;
import org.ff4j.core.FeatureStore;
import org.ff4j.core.FlippingExecutionContext;
import org.ff4j.strategy.AbstractFlipStrategy;
import org.ff4j.strategy.el.ExpressionNode;
import org.ff4j.strategy.el.ExpressionParser;

public class ExpressionFlipStrategy
extends AbstractFlipStrategy
implements Serializable {
    private static final long serialVersionUID = 4739173170455721752L;
    public static final String PARAM_EXPRESSION = "expression";
    private static Map<String, String> mapOfValue = new HashMap<String, String>();
    private static Map<String, ExpressionNode> cachedExpression = new HashMap<String, ExpressionNode>();

    public ExpressionFlipStrategy() {
    }

    public ExpressionFlipStrategy(String featureName, String expression) {
        this.getInitParams().put(PARAM_EXPRESSION, expression);
        mapOfValue.put(featureName, expression);
    }

    @Override
    public void init(String featureName, Map<String, String> initValue) {
        super.init(featureName, initValue);
        this.assertRequiredParameter(PARAM_EXPRESSION);
        mapOfValue.put(featureName, initValue.get(PARAM_EXPRESSION));
    }

    @Override
    public boolean evaluate(String featureName, FeatureStore currentStore, FlippingExecutionContext executionContext) {
        if (null != executionContext && executionContext.containsKey(PARAM_EXPRESSION)) {
            return this.evaluateExpression(executionContext.getString(PARAM_EXPRESSION), currentStore);
        }
        if (mapOfValue.containsKey(featureName)) {
            return this.evaluateExpression(mapOfValue.get(featureName), currentStore);
        }
        return true;
    }

    private boolean evaluateExpression(String expression, FeatureStore currentStore) {
        if (!cachedExpression.containsKey(expression)) {
            cachedExpression.put(expression, ExpressionParser.parseExpression(expression));
        }
        return cachedExpression.get(expression).evalue(this.getFeaturesStatus(currentStore));
    }

    private Map<String, Boolean> getFeaturesStatus(FeatureStore currentStore) {
        HashMap<String, Boolean> bools = new HashMap<String, Boolean>();
        ArrayList<Feature> listOfFlip = new ArrayList<Feature>();
        listOfFlip.addAll(currentStore.readAll().values());
        for (Feature fp : listOfFlip) {
            bools.put(fp.getUid(), fp.isEnable());
        }
        return bools;
    }
}

