/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.utils;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.ff4j.core.FlippingStrategy;
import org.ff4j.exception.FeatureAccessException;
import org.ff4j.property.PropertyBigDecimal;
import org.ff4j.property.PropertyBigInteger;
import org.ff4j.property.PropertyBoolean;
import org.ff4j.property.PropertyByte;
import org.ff4j.property.PropertyCalendar;
import org.ff4j.property.PropertyDate;
import org.ff4j.property.PropertyDouble;
import org.ff4j.property.PropertyFloat;
import org.ff4j.property.PropertyInt;
import org.ff4j.property.PropertyLogLevel;
import org.ff4j.property.PropertyLong;
import org.ff4j.property.PropertyShort;
import org.ff4j.property.PropertyString;
import org.ff4j.utils.Util;

public class MappingUtil {
    private static final String SEPARATOR = "&";
    private static Map<String, String> PROPERTY_TYPES = new HashMap<String, String>();

    private MappingUtil() {
    }

    public static String mapPropertyType(String pType) {
        if (pType == null) {
            return null;
        }
        if (PROPERTY_TYPES.containsKey(pType.toLowerCase())) {
            return PROPERTY_TYPES.get(pType.toLowerCase());
        }
        return pType;
    }

    public static String mapSimpleType(String className) {
        if (className == null) {
            return className;
        }
        if (PROPERTY_TYPES.containsValue(className)) {
            return Util.getFirstKeyByValue(PROPERTY_TYPES, className);
        }
        return className;
    }

    public static String mapSimpleType(Class<?> pType) {
        if (pType == null) {
            return null;
        }
        return MappingUtil.mapSimpleType(pType.getName());
    }

    public static final String fromMap(Map<String, String> params) {
        StringBuilder strBulBuilder = new StringBuilder();
        boolean first = true;
        if (params != null && !params.isEmpty()) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                if (!first) {
                    strBulBuilder.append(SEPARATOR);
                }
                strBulBuilder.append(entry.getKey() + "=" + entry.getValue());
                first = false;
            }
        }
        return strBulBuilder.toString();
    }

    public static final Map<String, String> toMap(String strParam) {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        if (strParam != null) {
            String[] chunks;
            for (String chunk : chunks = strParam.split("\\&")) {
                int idxEqual = chunk.indexOf("=");
                if (idxEqual <= 0 || idxEqual >= chunk.length()) continue;
                String paramName = chunk.substring(0, idxEqual);
                String paramValue = chunk.substring(idxEqual + 1);
                parameters.put(paramName, paramValue);
            }
        }
        return parameters;
    }

    public static FlippingStrategy instanceFlippingStrategy(String uid, String className, Map<String, String> initparams) {
        try {
            FlippingStrategy flipStrategy = (FlippingStrategy)Class.forName(className).newInstance();
            flipStrategy.init(uid, initparams);
            return flipStrategy;
        }
        catch (Exception ie) {
            throw new FeatureAccessException("Cannot instantiate Strategy, no default constructor available", ie);
        }
    }

    static {
        PROPERTY_TYPES.put("byte", PropertyByte.class.getName());
        PROPERTY_TYPES.put("boolean", PropertyBoolean.class.getName());
        PROPERTY_TYPES.put("bigdecimal", PropertyBigDecimal.class.getName());
        PROPERTY_TYPES.put("biginteger", PropertyBigInteger.class.getName());
        PROPERTY_TYPES.put("calendar", PropertyCalendar.class.getName());
        PROPERTY_TYPES.put("date", PropertyDate.class.getName());
        PROPERTY_TYPES.put("double", PropertyDouble.class.getName());
        PROPERTY_TYPES.put("float", PropertyFloat.class.getName());
        PROPERTY_TYPES.put("int", PropertyInt.class.getName());
        PROPERTY_TYPES.put("loglevel", PropertyLogLevel.class.getName());
        PROPERTY_TYPES.put("short", PropertyShort.class.getName());
        PROPERTY_TYPES.put("long", PropertyLong.class.getName());
        PROPERTY_TYPES.put("string", PropertyString.class.getName());
    }
}

