/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.utils;

import java.awt.Color;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.type.NullType;
import org.ff4j.audit.Event;

public class Util {
    private static final String START_COLOR = "00AB8B";
    private static final String END_COLOR = "EEFFEE";

    private Util() {
    }

    public static boolean hasLength(String expression) {
        return expression != null && !"".equals(expression);
    }

    public static boolean isValidClass(Class<?> clazz) {
        return clazz != null && clazz != NullType.class;
    }

    public static void assertTrue(boolean expression) {
        if (!expression) {
            throw new IllegalArgumentException("[Assertion failed] - this expression must be true");
        }
    }

    public static void assertNull(Object object) {
        if (object != null) {
            throw new IllegalArgumentException("[Assertion failed] - the object argument must be null");
        }
    }

    public static void assertEvent(Event evt) {
        Util.assertNotNull(evt);
        Util.assertHasLength(evt.getName());
        Util.assertHasLength(evt.getType());
        Util.assertHasLength(evt.getAction());
    }

    public static void assertNotNull(Object ... params) {
        Util.assertNotNull("parameter", params);
    }

    public static void assertNotNull(String objectName, Object ... params) {
        if (params == null) {
            throw new IllegalArgumentException("[Assertion failed] - " + objectName + " must not be null");
        }
        for (int idx = 0; idx < params.length; ++idx) {
            Object currentparam = params[idx];
            if (null != currentparam) continue;
            throw new IllegalArgumentException("[Assertion failed] - " + objectName + " must not be null");
        }
    }

    public static void assertHasLength(String ... params) {
        if (params == null) {
            throw new IllegalArgumentException("[Assertion failed] - Parameter #0 (string)  must not be null nor empty");
        }
        if (params != null) {
            for (int idx = 0; idx < params.length; ++idx) {
                String currentparam = params[idx];
                if (null != currentparam && !currentparam.isEmpty()) continue;
                throw new IllegalArgumentException("[Assertion failed] - Parameter #" + idx + "(string)  must not be null nor empty");
            }
        }
    }

    public static void assertNotEmpty(Collection<?> collec) {
        if (null == collec || collec.isEmpty()) {
            throw new IllegalArgumentException("[Assertion failed] - Target COLLECTION must not be null nor empty");
        }
    }

    public static void assertParamHasLength(String param, String paramName) {
        if (param == null || param.isEmpty()) {
            throw new IllegalArgumentException("Missing Parameter '" + paramName + "' must not be null nor empty");
        }
    }

    public static void assertParamHasNotNull(Object param, String paramName) {
        if (param == null) {
            throw new IllegalArgumentException("Missing Parameter '" + paramName + "' must not be null nor empty");
        }
    }

    public static <T> Set<T> set(T ... els) {
        if (els == null) {
            return null;
        }
        return new HashSet<T>(Arrays.asList(els));
    }

    public static <T> List<T> list(T ... els) {
        if (els == null) {
            return null;
        }
        return new ArrayList<T>(Arrays.asList(els));
    }

    public static <T> String join(Collection<T> collec, String delimiter) {
        Util.assertNotNull(delimiter, new Object[0]);
        if (collec == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (T t : collec) {
            if (!first) {
                sb.append(",");
            }
            sb.append(t.toString());
            first = false;
        }
        return sb.toString();
    }

    public static boolean isClassCollection(Class<?> c) {
        return Collection.class.isAssignableFrom(c) || Map.class.isAssignableFrom(c);
    }

    public static boolean isCollection(Object ob) {
        return ob != null && Util.isClassCollection(ob.getClass());
    }

    public static boolean isEmpty(Collection<?> ob) {
        return ob == null || ob.isEmpty();
    }

    public static <T> Collection<T> asCollection(Object ob) {
        if (ob == null) {
            return null;
        }
        if (ob.getClass().isArray()) {
            return Arrays.asList((Object[])ob);
        }
        if (!Util.isCollection(ob)) {
            throw new IllegalArgumentException("Target Object is not collection");
        }
        return (Collection)ob;
    }

    public static int getRandomOffset(int size) {
        return (int)(Math.random() * (double)Math.abs(size));
    }

    public static <T> T getRandomElement(List<T> myList) {
        return myList.get(Util.getRandomOffset(myList.size()));
    }

    public static List<String> generateRGBGradient(String codeFrom, String codeTo, int nbDivision) {
        ArrayList<String> colors = new ArrayList<String>();
        if (nbDivision < 1) {
            nbDivision = 1;
        }
        ++nbDivision;
        int r1 = Integer.parseInt(codeFrom.substring(0, 2), 16);
        int g1 = Integer.parseInt(codeFrom.substring(2, 4), 16);
        int b1 = Integer.parseInt(codeFrom.substring(4, 6), 16);
        int r2 = Integer.parseInt(codeTo.substring(0, 2), 16);
        int g2 = Integer.parseInt(codeTo.substring(2, 4), 16);
        int b2 = Integer.parseInt(codeTo.substring(4, 6), 16);
        int rDelta = (r2 - r1) / nbDivision;
        int gDelta = (g2 - g1) / nbDivision;
        int bDelta = (b2 - b1) / nbDivision;
        for (int idx = 0; idx < nbDivision; ++idx) {
            String red = Integer.toHexString(r1 + rDelta * idx);
            String green = Integer.toHexString(g1 + gDelta * idx);
            String blue = Integer.toHexString(b1 + bDelta * idx);
            colors.add(red + green + blue);
        }
        return colors.subList(1, colors.size());
    }

    public static List<String> generateHSVGradient(String codeFrom, String codeTo, int nbDivision) {
        int r1 = Integer.parseInt(codeFrom.substring(0, 2), 16);
        int g1 = Integer.parseInt(codeFrom.substring(2, 4), 16);
        int b1 = Integer.parseInt(codeFrom.substring(4, 6), 16);
        int r2 = Integer.parseInt(codeTo.substring(0, 2), 16);
        int g2 = Integer.parseInt(codeTo.substring(2, 4), 16);
        int b2 = Integer.parseInt(codeTo.substring(4, 6), 16);
        float[] startHSB = Color.RGBtoHSB(r1, g1, b1, null);
        float[] endHSB = Color.RGBtoHSB(r2, g2, b2, null);
        float brightness = (startHSB[2] + endHSB[2]) / 2.0f;
        float saturation = (startHSB[1] + endHSB[1]) / 2.0f;
        float hueMax = 0.0f;
        float hueMin = 0.0f;
        if (startHSB[0] > endHSB[0]) {
            hueMax = startHSB[0];
            hueMin = endHSB[0];
        } else {
            hueMin = startHSB[0];
            hueMax = endHSB[0];
        }
        ArrayList<String> colors = new ArrayList<String>();
        for (int idx = 0; idx < nbDivision; ++idx) {
            float hue = (hueMax - hueMin) * (float)idx / (float)nbDivision + hueMin;
            int rgbColor = Color.HSBtoRGB(hue, saturation, brightness);
            colors.add(Integer.toHexString(rgbColor).substring(2));
        }
        return colors;
    }

    public static List<String> getColorsGradient(int nbsectors) {
        return Util.generateRGBGradient(START_COLOR, END_COLOR, nbsectors);
    }

    public static <T> T instanciatePrivate(Class<T> utilityClass) throws Exception {
        Constructor<T> ce = utilityClass.getDeclaredConstructor(new Class[0]);
        ce.setAccessible(true);
        return ce.newInstance(new Object[0]);
    }

    public static <T, E> Set<T> getKeysByValue(Map<T, E> map, E value) {
        if (map == null) {
            return null;
        }
        HashSet<T> keys = new HashSet<T>();
        for (Map.Entry<T, E> entry : map.entrySet()) {
            if (value == null || !value.equals(entry.getValue())) continue;
            keys.add(entry.getKey());
        }
        return keys;
    }

    public static <T, E> T getFirstKeyByValue(Map<T, E> map, E value) {
        if (map == null) {
            return null;
        }
        for (Map.Entry<T, E> entry : map.entrySet()) {
            if (value == null || !value.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }
}

