/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.audit;

import java.util.concurrent.Callable;
import org.ff4j.audit.Event;
import org.ff4j.audit.repository.EventRepository;

public class EventWorker
implements Callable<Boolean> {
    private Event event = null;
    private String name = null;
    private EventRepository eventRepository = null;
    private static final int MAX_RETRY = 3;
    private static final long RETRY_DELAY = 500L;

    public EventWorker(Event e, EventRepository repo) {
        this.event = e;
        this.eventRepository = repo;
        if (e != null) {
            this.name = e.getTimestamp() + "-" + e.getAction() + "-" + e.getName();
        }
    }

    @Override
    public Boolean call() throws Exception {
        boolean ok = false;
        int retryCount = 0;
        while (!ok && retryCount < 3) {
            ok = this.eventRepository.saveEvent(this.event);
            if (ok) continue;
            ++retryCount;
            Thread.sleep(500L);
        }
        return ok;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

