/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.cache;

import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.ff4j.cache.FF4JCacheManager;
import org.ff4j.cache.InMemoryCacheEntry;
import org.ff4j.core.Feature;
import org.ff4j.property.Property;

public class InMemoryCacheManager
implements FF4JCacheManager {
    public static final String DEFAULT_CACHENAME = "ff4j-cache";
    private final Map<String, InMemoryCacheEntry<Feature>> featuresCache = new WeakHashMap<String, InMemoryCacheEntry<Feature>>();
    private final Map<String, InMemoryCacheEntry<Property<?>>> propertyCache = new WeakHashMap();

    @Override
    public String getCacheProviderName() {
        return "InMemory";
    }

    @Override
    public Set<String> listCachedFeatureNames() {
        return this.featuresCache.keySet();
    }

    @Override
    public void clearFeatures() {
        this.getFeaturesCache().clear();
    }

    @Override
    public void clearProperties() {
        this.getPropertyCache().clear();
    }

    @Override
    public void evictFeature(String featureId) {
        if (this.getFeaturesCache().containsKey(featureId)) {
            this.getFeaturesCache().remove(featureId);
        }
    }

    @Override
    public void evictProperty(String propertyName) {
        if (this.getPropertyCache().containsKey(propertyName)) {
            this.getPropertyCache().remove(propertyName);
        }
    }

    @Override
    public void putFeature(Feature feat) {
        if (feat == null) {
            throw new IllegalArgumentException("ff4j-core: Cannot insert null feature into cache");
        }
        if (feat.getUid() == null || feat.getUid().isEmpty()) {
            throw new IllegalArgumentException("ff4j-core: Cannot insert feature with null identifier into cache");
        }
        this.getFeaturesCache().put(feat.getUid(), new InMemoryCacheEntry<Feature>(feat));
    }

    public void putFeature(Feature feat, long timeToLive) {
        if (feat == null) {
            throw new IllegalArgumentException("ff4j-core: Cannot insert null feature into cache");
        }
        if (feat.getUid() == null || feat.getUid().isEmpty()) {
            throw new IllegalArgumentException("ff4j-core: Cannot insert feature with null identifier into cache");
        }
        this.getFeaturesCache().put(feat.getUid(), new InMemoryCacheEntry<Feature>(feat, timeToLive));
    }

    @Override
    public void putProperty(Property<?> prop) {
        if (prop == null) {
            throw new IllegalArgumentException("ff4j-core: Cannot insert null property into cache");
        }
        if (prop.getName() == null || prop.getName().isEmpty()) {
            throw new IllegalArgumentException("ff4j-core: Cannot insert property with null identifier into cache");
        }
        this.getPropertyCache().put(prop.getName(), new InMemoryCacheEntry(prop));
    }

    public void putProperty(Property<?> prop, long timeToLive) {
        if (prop == null) {
            throw new IllegalArgumentException("ff4j-core: Cannot insert null property into cache");
        }
        if (prop.getName() == null || prop.getName().isEmpty()) {
            throw new IllegalArgumentException("ff4j-core: Cannot insert property with null identifier into cache");
        }
        this.getPropertyCache().put(prop.getName(), new InMemoryCacheEntry(prop, timeToLive));
    }

    @Override
    public Feature getFeature(String featureId) {
        InMemoryCacheEntry<Feature> cacheEntry = this.getFeaturesCache().get(featureId);
        if (cacheEntry != null) {
            if (cacheEntry.hasReachTimeToLive()) {
                this.evictFeature(featureId);
            } else {
                return cacheEntry.getEntry();
            }
        }
        return null;
    }

    @Override
    public Property<?> getProperty(String pName) {
        InMemoryCacheEntry<Property<?>> cacheEntry = this.getPropertyCache().get(pName);
        if (cacheEntry != null) {
            if (cacheEntry.hasReachTimeToLive()) {
                this.evictProperty(pName);
            } else {
                return cacheEntry.getEntry();
            }
        }
        return null;
    }

    @Override
    public Set<String> listCachedPropertyNames() {
        return this.propertyCache.keySet();
    }

    @Override
    public Object getFeatureNativeCache() {
        return this.getFeaturesCache();
    }

    @Override
    public Object getPropertyNativeCache() {
        return this.getPropertyCache();
    }

    public Map<String, InMemoryCacheEntry<Feature>> getFeaturesCache() {
        return this.featuresCache;
    }

    public Map<String, InMemoryCacheEntry<Property<?>>> getPropertyCache() {
        return this.propertyCache;
    }
}

