/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.property;

import java.util.Arrays;
import java.util.HashSet;
import org.ff4j.exception.InvalidPropertyTypeException;
import org.ff4j.property.Property;

public class PropertyBoolean
extends Property<Boolean> {
    private static final long serialVersionUID = -3108407128242804565L;

    public PropertyBoolean() {
    }

    public PropertyBoolean(String name) {
        super(name);
    }

    public PropertyBoolean(String uid, String value) {
        super(uid, value);
        this.setFixedValues(new HashSet<Boolean>(Arrays.asList(Boolean.TRUE, Boolean.FALSE)));
    }

    public PropertyBoolean(String uid, boolean lvl) {
        super(uid, Boolean.valueOf(lvl), Boolean.TRUE, Boolean.FALSE);
    }

    @Override
    public Boolean fromString(String v) {
        if (!Boolean.TRUE.toString().equals(v.toLowerCase()) && !Boolean.FALSE.toString().equals(v)) {
            throw new InvalidPropertyTypeException("Cannot cast " + v + "to expected " + Boolean.class);
        }
        return new Boolean(v);
    }
}

