/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.property.store;

import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.ff4j.conf.XmlParser;
import org.ff4j.property.Property;
import org.ff4j.property.store.AbstractPropertyStore;
import org.ff4j.utils.Util;

public class InMemoryPropertyStore
extends AbstractPropertyStore {
    private Map<String, Property<?>> properties = new LinkedHashMap();
    private String fileName;

    public InMemoryPropertyStore() {
    }

    public InMemoryPropertyStore(String fileName) {
        if (fileName == null || fileName.isEmpty()) {
            throw new IllegalArgumentException("fileName is required, cannot be null nor empty : the file must exist in classpath");
        }
        this.loadConfFile(fileName);
    }

    public InMemoryPropertyStore(InputStream xmlIN) {
        this.loadConf(xmlIN);
    }

    public InMemoryPropertyStore(Map<String, Property<?>> maps) {
        this.properties = maps;
    }

    private void loadConfFile(String conf) {
        this.fileName = conf;
        this.loadConf(this.getClass().getClassLoader().getResourceAsStream(conf));
    }

    private void loadConf(InputStream xmlIN) {
        if (xmlIN == null) {
            throw new IllegalArgumentException("Cannot parse stream with properties");
        }
        this.properties = new XmlParser().parseConfigurationFile(xmlIN).getProperties();
    }

    @Override
    public boolean existProperty(String name) {
        Util.assertHasLength(name);
        return this.properties.containsKey(name);
    }

    @Override
    public <T> void createProperty(Property<T> value) {
        this.assertPropertyNotNull(value);
        this.assertPropertyNotExist(value.getName());
        this.properties.put(value.getName(), value);
    }

    @Override
    public Property<?> readProperty(String name) {
        this.assertPropertyExist(name);
        return this.properties.get(name);
    }

    @Override
    public void deleteProperty(String name) {
        this.assertPropertyExist(name);
        this.properties.remove(name);
    }

    @Override
    public Set<String> listPropertyNames() {
        if (this.properties == null) {
            return null;
        }
        return this.properties.keySet();
    }

    @Override
    public void clear() {
        if (this.properties != null) {
            this.properties.clear();
        }
    }

    @Override
    public Map<String, Property<?>> readAllProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Property<?>> properties) {
        this.properties = properties;
    }

    public void setLocation(String locations) {
        this.loadConfFile(locations);
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }
}

