/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.store;

import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.ff4j.conf.XmlConfig;
import org.ff4j.conf.XmlParser;
import org.ff4j.core.Feature;
import org.ff4j.core.FeatureStore;
import org.ff4j.exception.FeatureAlreadyExistException;
import org.ff4j.exception.FeatureNotFoundException;
import org.ff4j.exception.GroupNotFoundException;
import org.ff4j.utils.JsonUtils;
import org.ff4j.utils.Util;

public abstract class AbstractFeatureStore
implements FeatureStore {
    public Map<String, Feature> importFeaturesFromXmlFile(String xmlConfFile) {
        if (xmlConfFile == null || xmlConfFile.isEmpty()) {
            throw new IllegalArgumentException("Configuration filename cannot be null nor empty");
        }
        InputStream xmlIS = this.getClass().getClassLoader().getResourceAsStream(xmlConfFile);
        if (xmlIS == null) {
            throw new IllegalArgumentException("File " + xmlConfFile + " could not be read, please check path and rights");
        }
        XmlConfig conf = new XmlParser().parseConfigurationFile(xmlIS);
        Map<String, Feature> features = conf.getFeatures();
        this.importFeatures(features.values());
        return features;
    }

    @Override
    public void enable(String uid) {
        Feature f = this.read(uid);
        f.enable();
        this.update(f);
    }

    @Override
    public void disable(String uid) {
        Feature f = this.read(uid);
        f.disable();
        this.update(f);
    }

    @Override
    public void grantRoleOnFeature(String flipId, String roleName) {
        Util.assertParamHasLength(roleName, "roleName (#2)");
        Feature f = this.read(flipId);
        f.getPermissions().add(roleName);
        this.update(f);
    }

    @Override
    public void removeRoleFromFeature(String flipId, String roleName) {
        Util.assertParamHasLength(roleName, "roleName (#2)");
        Feature f = this.read(flipId);
        f.getPermissions().remove(roleName);
        this.update(f);
    }

    @Override
    public Map<String, Feature> readGroup(String groupName) {
        Util.assertParamHasLength(groupName, "groupName");
        Map<String, Feature> features = this.readAll();
        HashMap<String, Feature> group = new HashMap<String, Feature>();
        for (Map.Entry<String, Feature> uid : features.entrySet()) {
            if (!groupName.equals(uid.getValue().getGroup())) continue;
            group.put(uid.getKey(), uid.getValue());
        }
        if (group.isEmpty()) {
            throw new GroupNotFoundException(groupName);
        }
        return group;
    }

    @Override
    public boolean existGroup(String groupName) {
        Util.assertParamHasLength(groupName, "groupName");
        Map<String, Feature> features = this.readAll();
        HashMap<String, Feature> group = new HashMap<String, Feature>();
        for (Map.Entry<String, Feature> uid : features.entrySet()) {
            if (!groupName.equals(uid.getValue().getGroup())) continue;
            group.put(uid.getKey(), uid.getValue());
        }
        return !group.isEmpty();
    }

    @Override
    public void enableGroup(String groupName) {
        Map<String, Feature> features = this.readGroup(groupName);
        for (Map.Entry<String, Feature> uid : features.entrySet()) {
            uid.getValue().enable();
            this.update(uid.getValue());
        }
    }

    @Override
    public void disableGroup(String groupName) {
        Map<String, Feature> features = this.readGroup(groupName);
        for (Map.Entry<String, Feature> uid : features.entrySet()) {
            uid.getValue().disable();
            this.update(uid.getValue());
        }
    }

    @Override
    public void addToGroup(String featureId, String groupName) {
        Util.assertParamHasLength(groupName, "groupName (#2)");
        Feature f = this.read(featureId);
        f.setGroup(groupName);
        this.update(f);
    }

    @Override
    public void removeFromGroup(String featureId, String groupName) {
        Util.assertParamHasLength(groupName, "groupName (#2)");
        if (!this.existGroup(groupName)) {
            throw new GroupNotFoundException(groupName);
        }
        Feature f = this.read(featureId);
        f.setGroup(null);
        this.update(f);
    }

    @Override
    public Set<String> readAllGroups() {
        Map<String, Feature> features = this.readAll();
        HashSet<String> groups = new HashSet<String>();
        for (Map.Entry<String, Feature> uid : features.entrySet()) {
            groups.add(uid.getValue().getGroup());
        }
        groups.remove(null);
        groups.remove("");
        return groups;
    }

    @Override
    public void createSchema() {
    }

    @Override
    public void importFeatures(Collection<Feature> features) {
        if (features != null) {
            for (Feature feature : features) {
                if (this.exist(feature.getUid())) {
                    this.delete(feature.getUid());
                }
                this.create(feature);
            }
        }
    }

    public String toJson() {
        StringBuilder sb = new StringBuilder("{");
        sb.append("\"type\":\"" + this.getClass().getName() + "\"");
        sb.append(JsonUtils.cacheJson(this));
        Set<String> myFeatures = this.readAll().keySet();
        sb.append(",\"numberOfFeatures\":" + myFeatures.size());
        sb.append(",\"features\":[");
        boolean first = true;
        for (String myFeature : myFeatures) {
            if (!first) {
                sb.append(",");
            }
            first = false;
            sb.append("\"" + myFeature + "\"");
        }
        Set<String> myGroups = this.readAllGroups();
        sb.append("],\"numberOfGroups\":" + myGroups.size());
        sb.append(",\"groups\":[");
        first = true;
        for (String myGroup : myGroups) {
            if (!first) {
                sb.append(",");
            }
            first = false;
            sb.append("\"" + myGroup + "\"");
        }
        sb.append("]");
        sb.append("}");
        return sb.toString();
    }

    public String toString() {
        return this.toJson();
    }

    protected void assertFeatureExist(String uid) {
        Util.assertHasLength(uid);
        if (!this.exist(uid)) {
            throw new FeatureNotFoundException(uid);
        }
    }

    protected void assertFeatureNotExist(String uid) {
        Util.assertHasLength(uid);
        if (this.exist(uid)) {
            throw new FeatureAlreadyExistException(uid);
        }
    }

    protected void assertGroupExist(String groupName) {
        Util.assertHasLength(groupName);
        if (!this.existGroup(groupName)) {
            throw new GroupNotFoundException(groupName);
        }
    }

    protected void assertFeatureNotNull(Feature feature) {
        if (feature == null) {
            throw new IllegalArgumentException("Feature cannot be null nor empty");
        }
    }
}

