/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.store;

import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.ff4j.conf.XmlParser;
import org.ff4j.core.Feature;
import org.ff4j.store.AbstractFeatureStore;
import org.ff4j.utils.Util;

public class InMemoryFeatureStore
extends AbstractFeatureStore {
    private String fileName = null;
    private Map<String, Feature> featuresMap = new LinkedHashMap<String, Feature>();
    private Map<String, Set<String>> featureGroups = new HashMap<String, Set<String>>();

    public InMemoryFeatureStore() {
    }

    public InMemoryFeatureStore(String fileName) {
        if (fileName == null || fileName.isEmpty()) {
            throw new IllegalArgumentException("fileName is required, cannot be null nor empty : the file must exist in classpath");
        }
        this.createSchema();
        this.loadConfFile(fileName);
    }

    public InMemoryFeatureStore(InputStream xmlIN) {
        this.createSchema();
        this.loadConf(xmlIN);
    }

    public InMemoryFeatureStore(Map<String, Feature> maps) {
        this.createSchema();
        this.featuresMap = maps;
        this.buildGroupsFromFeatures();
    }

    private void loadConfFile(String conf) {
        this.fileName = conf;
        this.loadConf(this.getClass().getClassLoader().getResourceAsStream(conf));
    }

    private void loadConf(InputStream xmlIN) {
        if (xmlIN == null) {
            throw new IllegalArgumentException("Cannot parse feature stream");
        }
        this.featuresMap = new XmlParser().parseConfigurationFile(xmlIN).getFeatures();
        this.buildGroupsFromFeatures();
    }

    private void buildGroupsFromFeatures() {
        this.featureGroups = new HashMap<String, Set<String>>();
        for (Map.Entry<String, Feature> item : this.featuresMap.entrySet()) {
            String currentGroup = item.getValue().getGroup();
            if (!this.featureGroups.containsKey(currentGroup)) {
                this.featureGroups.put(currentGroup, new HashSet());
            }
            this.featureGroups.get(currentGroup).add(item.getKey());
        }
    }

    private void updateFeature(Feature fp) {
        this.featuresMap.put(fp.getUid(), fp);
        this.buildGroupsFromFeatures();
    }

    @Override
    public void create(Feature fp) {
        this.assertFeatureNotNull(fp);
        this.assertFeatureNotExist(fp.getUid());
        this.updateFeature(fp);
    }

    @Override
    public void update(Feature fp) {
        this.assertFeatureNotNull(fp);
        Feature fpExist = this.read(fp.getUid());
        HashSet<String> toBeAdded = new HashSet<String>();
        toBeAdded.addAll(fp.getPermissions());
        toBeAdded.removeAll(fpExist.getPermissions());
        for (String addee : toBeAdded) {
            this.grantRoleOnFeature(fpExist.getUid(), addee);
        }
        this.updateFeature(fp);
    }

    @Override
    public void delete(String uid) {
        this.assertFeatureExist(uid);
        this.featuresMap.remove(uid);
        this.buildGroupsFromFeatures();
    }

    @Override
    public void grantRoleOnFeature(String uid, String roleName) {
        this.assertFeatureExist(uid);
        Util.assertHasLength(roleName);
        this.featuresMap.get(uid).getPermissions().add(roleName);
    }

    @Override
    public void removeRoleFromFeature(String uid, String roleName) {
        this.assertFeatureExist(uid);
        Util.assertHasLength(roleName);
        this.featuresMap.get(uid).getPermissions().remove(roleName);
    }

    @Override
    public boolean exist(String uid) {
        Util.assertHasLength(uid);
        return this.featuresMap.containsKey(uid);
    }

    @Override
    public void enable(String uid) {
        this.assertFeatureExist(uid);
        this.featuresMap.get(uid).enable();
    }

    @Override
    public void disable(String uid) {
        this.assertFeatureExist(uid);
        this.featuresMap.get(uid).disable();
    }

    @Override
    public Feature read(String uid) {
        this.assertFeatureExist(uid);
        return this.featuresMap.get(uid);
    }

    @Override
    public boolean existGroup(String groupName) {
        Util.assertHasLength(groupName);
        return this.featureGroups.containsKey(groupName);
    }

    @Override
    public void enableGroup(String groupName) {
        this.assertGroupExist(groupName);
        for (String feat : this.featureGroups.get(groupName)) {
            this.enable(feat);
        }
    }

    @Override
    public void disableGroup(String groupName) {
        this.assertGroupExist(groupName);
        for (String feat : this.featureGroups.get(groupName)) {
            this.disable(feat);
        }
    }

    @Override
    public Map<String, Feature> readGroup(String groupName) {
        this.assertGroupExist(groupName);
        HashMap<String, Feature> features = new HashMap<String, Feature>();
        for (String feat : this.featureGroups.get(groupName)) {
            features.put(feat, this.read(feat));
        }
        return features;
    }

    @Override
    public Set<String> readAllGroups() {
        HashSet<String> groups = new HashSet<String>();
        groups.addAll(this.featureGroups.keySet());
        groups.remove(null);
        groups.remove("");
        return groups;
    }

    @Override
    public void addToGroup(String uid, String groupName) {
        Util.assertHasLength(uid);
        Util.assertHasLength(groupName);
        Feature feat = this.read(uid);
        feat.setGroup(groupName);
        this.update(feat);
    }

    @Override
    public void removeFromGroup(String uid, String groupName) {
        this.assertFeatureExist(uid);
        this.assertGroupExist(groupName);
        Feature feat = this.read(uid);
        feat.setGroup("");
        this.update(feat);
    }

    @Override
    public void clear() {
        this.featuresMap.clear();
    }

    @Override
    public Map<String, Feature> readAll() {
        return this.featuresMap;
    }

    @Override
    public String toJson() {
        String json = super.toJson();
        json = json.substring(0, json.length() - 1) + ",\"xmlInputFile\":";
        json = null == this.fileName ? json + "null" : json + "\"" + this.fileName + "\"";
        json = json + "}";
        return json;
    }

    public void setLocation(String locations) {
        this.loadConfFile(locations);
    }

    public String getFileName() {
        return this.fileName;
    }
}

