/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.store.kv;

import java.util.HashMap;
import java.util.Map;
import org.ff4j.core.Feature;
import org.ff4j.exception.FeatureAlreadyExistException;
import org.ff4j.exception.FeatureNotFoundException;
import org.ff4j.mapper.FeatureMapper;
import org.ff4j.store.AbstractFeatureStore;
import org.ff4j.store.kv.KeyValueDriver;
import org.ff4j.utils.Util;

public abstract class KeyValueFeatureStore<VALUE>
extends AbstractFeatureStore {
    protected KeyValueDriver<String, VALUE> driver;
    protected FeatureMapper<VALUE> featureMapper;

    public KeyValueFeatureStore() {
    }

    public KeyValueFeatureStore(KeyValueDriver<String, VALUE> driver) {
        this.driver = driver;
    }

    public KeyValueFeatureStore(KeyValueDriver<String, VALUE> driver, FeatureMapper<VALUE> mapper) {
        this.driver = driver;
        this.featureMapper = mapper;
    }

    @Override
    public boolean exist(String uid) {
        Util.assertParamHasLength(uid, "Feature identifier");
        return this.getDriver().existKey(this.getDriver().getFeatureKey(uid));
    }

    @Override
    public void update(Feature feature) {
        if (feature == null) {
            throw new IllegalArgumentException("Feature cannot be null");
        }
        if (!this.exist(feature.getUid())) {
            throw new FeatureNotFoundException(feature.getUid());
        }
        this.getDriver().putValue(this.getDriver().getFeatureKey(feature.getUid()), this.getFeatureMapper().toStore(feature));
    }

    @Override
    public Feature read(String uid) {
        if (!this.exist(uid)) {
            throw new FeatureNotFoundException(uid);
        }
        return (Feature)this.getFeatureMapper().fromStore(this.getDriver().getValue(this.getDriver().getFeatureKey(uid)));
    }

    @Override
    public Map<String, Feature> readAll() {
        HashMap<String, Feature> mapOfFeatures = new HashMap<String, Feature>();
        for (String featureName : this.getDriver().getFeatureList()) {
            Feature currF = (Feature)this.getFeatureMapper().fromStore(this.getDriver().getValue(this.getDriver().getFeatureKey(featureName)));
            mapOfFeatures.put(currF.getUid(), currF);
        }
        return mapOfFeatures;
    }

    @Override
    public void create(Feature feature) {
        if (feature == null) {
            throw new IllegalArgumentException("Feature cannot be null nor empty");
        }
        if (this.exist(feature.getUid())) {
            throw new FeatureAlreadyExistException(feature.getUid());
        }
        this.getDriver().putValue(this.getDriver().getFeatureKey(feature.getUid()), this.getFeatureMapper().toStore(feature));
        this.getDriver().registerFeature(feature.getUid());
    }

    @Override
    public void delete(String uid) {
        if (!this.exist(uid)) {
            throw new FeatureNotFoundException(uid);
        }
        this.getDriver().deleteKey(this.getDriver().getFeatureKey(uid));
        this.getDriver().unregisterFeature(uid);
    }

    @Override
    public void clear() {
        for (String uid : this.getDriver().getFeatureList()) {
            this.delete(uid);
        }
    }

    public KeyValueDriver<String, VALUE> getDriver() {
        if (this.driver == null) {
            throw new IllegalStateException("Cannot access target K/V driver, please initialize");
        }
        return this.driver;
    }

    public void setDriver(KeyValueDriver<String, VALUE> driver) {
        this.driver = driver;
    }

    public FeatureMapper<VALUE> getFeatureMapper() {
        if (this.featureMapper == null) {
            throw new IllegalStateException("Please initialize feature mapper");
        }
        return this.featureMapper;
    }

    public void setFeatureMapper(FeatureMapper<VALUE> featureMapper) {
        this.featureMapper = featureMapper;
    }
}

